package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.*;
import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.entity.*;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.rabbit.sender.GoodsSender;
import com.ekingwin.bas.cloud.rabbit.sender.OrderRejectSender;
import com.ekingwin.bas.cloud.reqno.utils.GenerateRequestCode;
import com.ekingwin.bas.cloud.service.AsyncService;
import com.ekingwin.bas.cloud.service.IpCustAddressService;
import com.ekingwin.bas.cloud.service.IpGoodsContractService;
import com.ekingwin.bas.cloud.service.IpcOrderService;
import com.ekingwin.bas.cloud.util.DateUtils;
import com.ekingwin.bas.cloud.util.MapObjUtil;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.*;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-02 10:38
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpcOrderServiceImpl implements IpcOrderService {


    @Autowired
    private IpOrderMapper ipOrderMapper;

    @Autowired
    private IpcOrderMapper ipcOrderMapper;

    @Autowired
    private IpcOrderAttachmentMapper ipcOrderAttachmentMapper;

    @Autowired
    private IpcOrderAllgoodsMapper  ipcOrderAllgoodsMapper;

    @Autowired
    private IpcOrderInvoiceMapper ipcOrderInvoiceMapper;

    @Autowired
    private AsyncService asyncService;

    @Autowired
    private IpGoodsContractService ipGoodsContractService;

    @Autowired
    private IpCustAddressService custAddressService;

    @Autowired
    private OrderRejectSender orderRejectSender;

    @Autowired
    private GoodsSender goodsSender;


    @Value("${goods.baseurl}")
    private String basPath;
    @Value("${dataSourceName}")
    private String businessUrl;
    @Value(value = "${img.url}")
    private String imgurl;

    @Override
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = Exception.class,isolation = Isolation.DEFAULT)
    public IpOrderResultVo saveOrUpdateOrder(IpOrderAddDto ipOrderAddDto) throws Exception{
        IpOrderResultVo ipOrderResultVo =new IpOrderResultVo();
        IpOrderDto ipOrderDto=ipOrderAddDto.getOrder();
        String orderNum=ipOrderDto.getOrdernum();
        String customerType=ipOrderAddDto.getCustomerType();
        String orderType=ipOrderDto.getOrdertype();
        //判断订单类型是否为空，若为空的话判断客户类型是项目还是人员
        if (StringUtils.isEmpty(orderType)){
            if (StringUtils.isEmpty(customerType)){
                customerType="XM";
            }
            ipOrderDto.setOrdertype(customerType);
        }
        //判断是否存在订单号，不存在则生成订单号
        if (StringUtils.isEmpty(orderNum)){
            //orderNum=ipOrderMapper.getOrderNum();
            orderNum= GenerateRequestCode.
                    requestCode("orderNum",GenerateRequestCode.YEARMONTHDAY,4,null);
        }
        ipOrderDto.setOrdernum(orderNum);

        //保存主表信息
        long orderId=this.saveOrUpdateOrderMain(ipOrderAddDto);

        //保存附件信息
        this.saveOrderAttement(orderNum,ipOrderAddDto);

        //保存商品信息、零售商品扣减库存
        this.saveOrUpdateGoods(orderNum,ipOrderAddDto,orderId);

        //保存发票信息
        this.saveOrUpdateInvoice(orderNum,ipOrderAddDto,orderId);
        ipOrderResultVo.setOrderId(orderId);
        ipOrderResultVo.setOrderNum(orderNum);
        String statusStr = ipOrderAddDto.getStatusStr();
      /*  if ("待付款".equals(statusStr) && "GR".equals(customerType)){
            //扣减库存
        }*/
        //异步发送发货通知邮件
        if(ipOrderAddDto.getStatusStr().equals("待发货")){
            asyncService.sendMailTask(orderNum);
        }
       return ipOrderResultVo;
    }

    /**
     * 保存订单主表信息
     * @param ipOrderAddDto
     * @return
     */
    private Long saveOrUpdateOrderMain(IpOrderAddDto ipOrderAddDto) throws Exception{
        IpOrderDto ipOrderDto=ipOrderAddDto.getOrder();
        //订单ID
        Long orderId=ipOrderDto.getOrderId();
        IpcOrderWithBLOBs ipcOrder = new IpcOrderWithBLOBs();
        MapObjUtil.copy(ipOrderDto,ipcOrder);
        ipcOrder.setState(ipOrderAddDto.getStatusStr());
        ipcOrder.setIsdrafts("N");
        ipcOrder.setSurfacetype("1");
        ipcOrder.setIssupplier(ipOrderAddDto.getIsSupplier());
        ipcOrder.setAppproedate(ipOrderAddDto.getAppproedate());
        ipcOrder.setExpirationTime(ipOrderAddDto.getExpirationTime());
        if (orderId!=null){
            ipcOrder.setBpmid(Integer.parseInt(ipOrderAddDto.getInstid()));
            ipcOrder.setId(orderId);
            ipcOrderMapper.updateByPrimaryKeySelective(ipcOrder);
        }else {
            ipcOrder.setIssupplier(ipOrderAddDto.getIsSupplier());
            ipcOrder.setInputname(ipOrderAddDto.getUserName());
            ipcOrder.setInputperson(ipOrderAddDto.getUserid());
            ipcOrder.setInputdate(DateUtils.format(new Date(),DateUtils.DATE_TIME_PATTERN));
            ipcOrderMapper.insertSelective(ipcOrder);
            orderId=ipcOrder.getId();
        }

        return  orderId;
    }

    /**
     * 附件信息
     */
    private  void saveOrderAttement(String orderNum,IpOrderAddDto ipOrderAddDto) throws Exception{

        ipcOrderAttachmentMapper.deleteByOrderNum(orderNum);

        List<IpcOrderDraftsAttachmentDto> ipcOrderAttachments =ipOrderAddDto.getAttachments();

        if (ipcOrderAttachments !=null && ipcOrderAttachments.size()>0){
            IpcOrderAttachment  ipcOrderAttachment=null;

            for (IpcOrderDraftsAttachmentDto ipcOrderAttachmentDto : ipcOrderAttachments) {
                ipcOrderAttachment=new IpcOrderAttachment();
                MapObjUtil.copy(ipcOrderAttachmentDto,ipcOrderAttachment);
                ipcOrderAttachment.setOrdernum(orderNum);
                ipcOrderAttachmentMapper.insertSelective(ipcOrderAttachment);
            }
        }

    }

    /**
     * 保存商品信息
     * @param orderNum
     * @param ipOrderAddDto
     * @param orderid
     */
    private void saveOrUpdateGoods(String orderNum,IpOrderAddDto ipOrderAddDto,Long orderid) throws Exception{
        ipcOrderAllgoodsMapper.deleteByOrderid(orderid);
        String customerType = ipOrderAddDto.getCustomerType();
        String ordertype = ipOrderAddDto.getOrder().getOrdertype();
        List<IpOrderGoodDraftsDto> goods=ipOrderAddDto.getGoods();
        if (goods !=null && goods.size()>0){
            IpcOrderAllgoods ipcOrderAllgoods=null;
            for (IpOrderGoodDraftsDto good : goods) {
                ipcOrderAllgoods=new IpcOrderAllgoods();
                MapObjUtil.copy(good,ipcOrderAllgoods);
                ipcOrderAllgoods.setOrderid(orderid);
                ipcOrderAllgoods.setOrdernum(orderNum);
                ipcOrderAllgoods.setState(ipOrderAddDto.getStatusStr());
                ipcOrderAllgoods.setReceivedNum(this.getUserId(ipOrderAddDto,good.getSupportCode()));

                //判断若为零售商品，则需扣减库存
                if (StringUtils.isNotEmpty(customerType) && "GR".equals(customerType)){
                    String attrid = good.getAttrid();
                    this.deductionGoodsStock(good.getGoodsid().toString(),ordertype,good.getCount(),"success",attrid);
                }else{
                    this.deductionGoodsStock(good.getGoodsid().toString(),ordertype,good.getCount(),"success",null);
                    //判断是否是商票支付
                    String isticket = good.getIsticket();
                    if (StringUtils.isNotEmpty(isticket) && "1".equals(isticket)){

                        //当为商票支付的时候，商票价格则为价格
                        String tickettaxprice = good.getTickettaxprice().toString();
                        String ticketpricetotal = good.getTicketpricetotal();
                        BigDecimal ticketnotaxprice = good.getTicketnotaxprice();
                        String count = good.getCount();
                        if (StringUtils.isEmpty(count)){
                            count="0.0";
                        }
                        BigDecimal bigDecimal = new BigDecimal(count);
                        ipcOrderAllgoods.setPrice(tickettaxprice);
                        ipcOrderAllgoods.setHsprice(tickettaxprice);
                        ipcOrderAllgoods.setBhsprice(ticketnotaxprice.toString());
                        ipcOrderAllgoods.setGoodstotalhsprice(ticketpricetotal);
                        BigDecimal totalBhs = bigDecimal.multiply(ticketnotaxprice);
                        ipcOrderAllgoods.setGoodstotalbhsprice(totalBhs.toString());
                    }
                }
                ipcOrderAllgoodsMapper.insertSelective(ipcOrderAllgoods);
            }
        }
    }

    /**
     * 保存发票信息
     * @param orderNum
     * @param ipOrderAddDto
     * @param orderid
     * @throws Exception
     */
    public void  saveOrUpdateInvoice(String orderNum,IpOrderAddDto ipOrderAddDto,Long orderid) throws Exception{
        ipcOrderInvoiceMapper.deleteByOrderId(orderid);
        IpcOrderDraftsInvoiceDto ipcOrderDraftsInvoiceDto =ipOrderAddDto.getInvoiceinfo();
        if (ipcOrderDraftsInvoiceDto !=null){
            IpcOrderInvoice ipcOrderInvoice =new IpcOrderInvoice();
            MapObjUtil.copy(ipcOrderDraftsInvoiceDto,ipcOrderInvoice);
            ipcOrderInvoice.setOrderid(orderid);
            ipcOrderInvoice.setBillcontent(ipcOrderDraftsInvoiceDto.getInvoiceContent());
            ipcOrderInvoiceMapper.insertSelective(ipcOrderInvoice);

        }

    }

    /**
     *
     * @param ipOrderDetailDto
     * @return
     */
    @Override
   public IpOrderCarDetailVo getOrderCarDetail(IpOrderDetailDto ipOrderDetailDto) throws Exception{

       IpOrderCarDetailVo  ipOrderCarDetailVo = new IpOrderCarDetailVo();
       Long orderId=0L;
       if (StringUtils.isNotEmpty(ipOrderDetailDto.getInstid())){
        IpcOrder ipcOrder=ipcOrderMapper.selectByInstid(ipOrderDetailDto.getInstid());
           orderId=ipcOrder.getId();
           ipOrderDetailDto.setOrderId(orderId.toString());
       }else {
           orderId=Long.parseLong(ipOrderDetailDto.getOrderId());
       }
       IpOrderVo ipOrderVo=this.getOrderDetaiil(orderId);
       String ordernum=ipOrderVo.getOrdernum();

       //获取订单主数据
       ipOrderCarDetailVo.setOrder(ipOrderVo);

       //获取附件信息
        ipOrderCarDetailVo.setAttachments(this.getOrderAttement(ordernum));

        //获取订单商品数据
       ipOrderCarDetailVo.setGoods(this.getOrderGoods(ipOrderDetailDto));

       ipOrderCarDetailVo.setInvoiceinfo(ipcOrderInvoiceMapper.selectByOrderId(orderId));

       return ipOrderCarDetailVo;
    }

    /**
     * 根据流程实例号获取订单信息
     * @param instid
     * @return
     */
    @Override
    public  IpcOrder getOrderDetailByInstid(String instid){
        IpcOrder ipcOrder=ipcOrderMapper.selectByInstid(instid);
        return  ipcOrder;
    }

    /**
     * 查询订单主数据
     * @param orderId
     * @return
     */
    @Override
    public IpOrderVo getOrderDetaiil(Long orderId) throws Exception{
        IpOrderVo ipOrderVo = new IpOrderVo();
        IpcOrder ipcOrder=ipcOrderMapper.selectByPrimaryKey(orderId);
        if (ipcOrder !=null){
            MapObjUtil.copy(ipcOrder,ipOrderVo);
            ipOrderVo.setOrderId(ipcOrder.getId());
            ipOrderVo.setApplyCode(ipcOrder.getInputperson());
            ipOrderVo.setApplyUser(ipcOrder.getInputname());
            ipOrderVo.setApplyTime(ipcOrder.getInputdate());
            ipOrderVo.setOrderType(ipcOrder.getOrdertype());
        }
        return ipOrderVo;
    }

    /**
     * 根据单号获取附件1信息
     * @param orderNum
     * @return
     */
    private  List<IpcOrderDraftsAttachmentVo> getOrderAttement(String orderNum){

        List<IpcOrderDraftsAttachmentVo>  attachmentVoList=ipcOrderAttachmentMapper.selectByOrderNum(orderNum);

        return attachmentVoList;
    }


    /**
     * 获取订单商品数据
     * @param ipOrderDetailDto
     * @return
     */
    private List<IpOrderGoodsDetailVo> getOrderGoods(IpOrderDetailDto ipOrderDetailDto){
        List<IpOrderGoodsDetailVo> ipOrderGoodsDetailVos=ipOrderMapper.getOderGoods(ipOrderDetailDto);
        if (ipOrderGoodsDetailVos !=null && ipOrderGoodsDetailVos.size()>0){
            for (IpOrderGoodsDetailVo ipOrderGoodsDetailVo : ipOrderGoodsDetailVos) {
                if (StringUtils.isNotEmpty(ipOrderGoodsDetailVo.getUrlPath())){
                    ipOrderGoodsDetailVo.setUrlPath(basPath+ipOrderGoodsDetailVo.getUrlPath());
                }

            }
        }
        return ipOrderGoodsDetailVos;
    }




    /**
     * 根据当前登录人查询订单
     * @param
     * @return
     */
    @Override
    public PageInfo getOrderListByUserId(IpOrderMyListVo ipOrderMyListVo){
        PageHelper.startPage(ipOrderMyListVo.getPagenum(),ipOrderMyListVo.getCount());
        ipOrderMyListVo.setBusinessUrl(businessUrl);
        List<Map<String, Object>> maps = ipcOrderMapper.selectSuppliers(ipOrderMyListVo);
        if (maps !=null && maps.size()>0){
//            IpOrderDetailDto ipOrderDetailDto=null;
            for (Map<String, Object> map : maps) {
                String surfacetype=map.get("surfacetype")+"";
                if("1".equals(surfacetype)){
                    List<Map<String, Object>>  goodlists=new ArrayList<Map<String,Object>>();
                    ipOrderMyListVo.setSeq(map.get("seq")+"");
                    List<Map<String, Object>> goodsInfos = ipcOrderMapper.selectGoodsInfo(ipOrderMyListVo);
                    if(goodsInfos!=null && goodsInfos.size()>0){
                        for (Map<String, Object> goodsInfo : goodsInfos) {
                            Map<String ,Object> goodlist =new HashMap<String ,Object>();
                            goodlist=goodsInfo;
                            goodlist.put("inputpersonname",map.get("inputpersonname"));
                            goodlist.put("state",map.get("state"));
                            goodlist.put("name","");
                            goodlist.put("url","");
                            List<Map<String, Object>> goodsDetails = ipcOrderMapper.selectGoodsDetail(businessUrl, goodsInfo.get("goodsid") + "", imgurl);
                                if(goodsDetails!=null && goodsDetails.size()>0){
                                    if(StringUtils.isNotEmpty(goodsDetails.get(0).get("taxrate")+"")){
                                        goodlist.put("taxrate","0");
                                    }else{
                                        goodlist.put("taxrate",goodsDetails.get(0).get("taxrate")+"");
                                    }
                                    if(StringUtils.isNotEmpty(goodsDetails.get(0).get("wareid")+"")){
                                        goodlist.put("goodstype","京东");
                                    }else{
                                        goodlist.put("taxrate","非京东");
                                    }
                                    goodlist.put("name",goodsDetails.get(0).get("name")+"");
                                    goodlist.put("url",goodsDetails.get(0).get("url")+"");
                                    goodlist.put("currency",goodsDetails.get(0).get("currency")+"");
                                    //计算逻辑按照node里面的算法
                                    //(parseFloat(result[0].price)*(1-parseFloat(result[0].taxrate)/100)).toFixed(2)
                                    BigDecimal b1 = BigDecimal.valueOf(Double.valueOf(goodsDetails.get(0).get("price") + ""));
                                    BigDecimal b2 = BigDecimal.valueOf(Double.valueOf(goodsDetails.get(0).get("taxrate") + ""));
                                    BigDecimal b3 = BigDecimal.valueOf(1.0);
                                    BigDecimal divide = b1.divide(b2, BigDecimal.ROUND_HALF_UP);
                                    BigDecimal subtract = b3.subtract(divide);
                                    double v = subtract.multiply(divide).doubleValue();
                                    goodlist.put("bhsprice",v+"");
                                    goodlist.put("FTNPFirstCategoryCode",goodsDetails.get(0).get("FTNPFirstCategoryCode")+"");
                                    goodlist.put("FTNPFirstCategoryName",goodsDetails.get(0).get("FTNPFirstCategoryName")+"");
                                    goodlist.put("brand",goodsDetails.get(0).get("brand")+"");
                                    goodlist.put("FTNPSpecificationsModel",goodsDetails.get(0).get("FTNPSpecificationsModel")+"");
                                    goodlists.add(goodlist);

                                }
                        }
                    }
                    map.put("goodslist",goodlists);
                }

//                List<IpOrderGoodsDetailVo> goods=this.getOrderGoods(ipOrderDetailDto);
//                ipOrderListVo.setGoods(goods);
            }
        }
        PageInfo pageInfo = new PageInfo<>(maps);
        return  pageInfo;
    }

    /**
     * 修改商品的状态和修改商品的已收货数量
     * @return
     */
    @Override
    public int updateGoodsStatus(IpOrderGoodsStatusDto ipOrderGoodsStatusDto){

        return  ipcOrderAllgoodsMapper.updateGoodsStatus(ipOrderGoodsStatusDto);
    }
    /**
     * 修改商品的状态和修改商品的已发货数量
     * @return
     */
    @Override
    public int updateGoodsDeliverCount(IpOrderGoodsStatusDto ipOrderGoodsStatusDto){
        return ipcOrderAllgoodsMapper.updateGoodsDeliverCount(ipOrderGoodsStatusDto);
    }

    /**
     * 获取商品的收货数量
     * @param orderGoodsId
     * @return
     */
    @Override
    public BigDecimal getReceiverGoods(String orderGoodsId){
        return  ipcOrderAllgoodsMapper.getReceiverGoods(orderGoodsId);
    }

    /**
     * 获取发货数量
     * @param orderGoodsId
     * @return
     */
    @Override
    public BigDecimal getDeliverGoods(String orderGoodsId){
        return  ipcOrderAllgoodsMapper.getDeliverGoods(orderGoodsId);
    }

    /**
     * 修改收货单状态
     * @param ipOrderGoodsStatusDto
     * @return
     */
    @Override
    public int updateGoodsStatus1(IpOrderGoodsStatusDto ipOrderGoodsStatusDto){

        return ipcOrderAllgoodsMapper.updateGoodsStatus1(ipOrderGoodsStatusDto);
    }


    @Override
    public int updateOrderBpmId(IpOrderInstidDto instidDto){


        return  ipcOrderMapper.updateOrderBpmId(instidDto);

    }

    /**
     * 获取商品的收货人数据
     * @param ipOrderAddDto
     * @param type
     * @return
     */
   private String getUserId(IpOrderAddDto ipOrderAddDto,String  type){
        String code="";
       Set<String> ures= new HashSet<>();
       IpOrderDto ipOrderDto=ipOrderAddDto.getOrder();
       //项目负责人
       if (StringUtils.isNotEmpty(ipOrderDto.getProjectLeaderCode())){
            String  projectLeaderCode=ipOrderDto.getProjectLeaderCode();
           ures.add(projectLeaderCode);
       }
       //监理
       if (StringUtils.isNotEmpty(ipOrderDto.getSupervisorCode())){
           String  projectLeaderCode=ipOrderDto.getSupervisorCode();
           ures.add(projectLeaderCode);
       }
        //甲供
/*        if (type.equals("0")){
            if (StringUtils.isNotEmpty(ipOrderDto.getReceiverCode())){
                String  projectLeaderCode=ipOrderDto.getReceiverCode();
                String [] strs=projectLeaderCode.split(",");
                for (String str : strs) {
                    ures.add(str);
                }

            }
        }*/

        return String.join(",",ures);
    }

    /**
     * 流程结束更新数据
     * @param instid
     */
    @Override
    public void updatePassStatus(String instid) throws Exception{
        String status="待发货";
        ipcOrderMapper.updateOrderInstid(instid,status);
        ipcOrderAllgoodsMapper.updateStatusByInstid(instid,status);
        //根据流程id获取订单编号发送送货通知
        IpcOrderWithBLOBs orderWithBLOBs = ipcOrderMapper.selectByInstid(instid);
        asyncService.sendMailTask(orderWithBLOBs.getOrdernum());
    }

    /**
     * 流程结束更新数据
     * @param instid
     */
    @Override
    public void updateFailStatus(String instid) throws Exception{
        String status="审批不通过";
        ipcOrderMapper.updateOrderInstid(instid,status);
        ipcOrderAllgoodsMapper.updateStatusByInstid(instid,status);
        //合同占用的额度释放
        IpOrderDetailDto ipOrderDetailDto =new IpOrderDetailDto();
        ipOrderDetailDto.setInstid(instid);
        IpOrderCarDetailVo ipOrderCarDetailVo=this.getOrderCarDetail(ipOrderDetailDto);
        List<IpOrderGoodsDetailVo> goods=ipOrderCarDetailVo.getGoods();
        if (goods !=null &&  goods.size()>0){
            this.updateGoodContract(goods);
        }
    }

    /**
     * 释放合同
     * @param goods
     */
    private void updateGoodContract(List<IpOrderGoodsDetailVo> goods){
        IpContractGoodDto ipContractGoodDto=null;
        BigDecimal big =new BigDecimal("-1");
        for (IpOrderGoodsDetailVo good : goods) {
            ipContractGoodDto=new IpContractGoodDto();
            ipContractGoodDto.setContractCode(good.getContractCode());
            ipContractGoodDto.setGoodsnum(good.getGoodsnum());
            BigDecimal num=good.getCount();
            ipContractGoodDto.setNum(num.multiply(big));
            BigDecimal goodstotalhsprice = good.getGoodstotalhsprice();
            if (goodstotalhsprice==null){
                goodstotalhsprice=BigDecimal.valueOf(0);
            }
            ipContractGoodDto.setGoodsMoney(big.multiply(goodstotalhsprice));
            ipGoodsContractService.updateContractGoods(ipContractGoodDto);
        }
    }
    /**
     * 订单取消
     * @param orderCancelDto
     */
    @Override
    public void  orderCancel( OrderCancelDto orderCancelDto) throws Exception{
        Long orderId = orderCancelDto.getOrderId();
        String customerType = orderCancelDto.getCustomerType();
        String status="已取消";


        //处理订单信息，项目订单取消订单释放合同，零售订单退款释放库存
        IpOrderDetailDto ipOrderDetailDto =new IpOrderDetailDto();
        ipOrderDetailDto.setOrderId(orderId.toString());
        IpOrderCarDetailVo ipOrderCarDetailVo=this.getOrderCarDetail(ipOrderDetailDto);
        //验证订单状态
        this.checkOrder(ipOrderCarDetailVo);
        //处理订单状态
        ipcOrderMapper.updateOrderByOrderId(orderId,status);
        //处理订单商品状态
        ipcOrderAllgoodsMapper.updateStatusByOrderId(orderId,status);
        if (StringUtils.isNotEmpty(customerType)
                && "GR".equals(customerType)){
            //释放商品库存
            List<IpOrderGoodsDetailVo> goods=ipOrderCarDetailVo.getGoods();
            if (goods !=null && goods.size()>0){
                //商品库存恢复
                BigDecimal bigDecimal=new BigDecimal("-1");
                for (IpOrderGoodsDetailVo good : goods) {
                    String goodsid = good.getGoodsid().toString();
                    String attrid = good.getAttrid();
                    BigDecimal count = good.getCount().multiply(bigDecimal);
                    //库存恢复
                    this.deductionGoodsStock(goodsid,"GR",count.toString(),"fail",attrid);
                }
                IpOrderGoodsDetailVo ipOrderGoodsDetailVo = goods.get(0);
                //获取订单的状态
                String state = ipOrderGoodsDetailVo.getState();
                //判断是否订单的状态
                if (StringUtils.isNotEmpty(state)&& "待发货".equals(state)){
                    IpOrderVo order = ipOrderCarDetailVo.getOrder();
                    String totalhsprice = order.getTotalhsprice();
                    this.updateRejectGoodsConfim(ipOrderGoodsDetailVo,totalhsprice);
                }


            }
            //订单退款
        }else{
            //合同占用的额度释放
            List<IpOrderGoodsDetailVo> goods=ipOrderCarDetailVo.getGoods();
            if (goods !=null &&  goods.size()>0){
                this.updateGoodContract(goods);
            }
        }

    }

    private void  checkOrder(IpOrderCarDetailVo ipOrderCarDetailVo){
        List<IpOrderGoodsDetailVo> goods=ipOrderCarDetailVo.getGoods();
        boolean flag=false;
        Set<String> stateSet=new HashSet<String>();
        for (IpOrderGoodsDetailVo good : goods) {
             String state=good.getState();
            stateSet.add(state);
            if ("已取消".equals(state)){
                throw  new BusinessException(500, "此订单已取消，请勿重复操作");
            }
            if ("待付款".equals(state) || "待发货".equals(state)){
                flag=true;
            }
            if (!flag){
                break;
            }
        }
        if (!flag){
            if (stateSet.contains("待收货")){
                throw  new BusinessException(500, "商品已发货，无法取消订单！");
            }else {
                throw  new BusinessException(500, "无法取消订单！");
            }

        }

    }
    /**
     * 退款
     * @Param:  * @param goodsConfirmDto
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/26 17:04
     */
    private void  updateRejectGoodsConfim(IpOrderGoodsDetailVo good,String totalAmount) throws Exception{
        IpOrderRejectGoodsConfirmDto confirmDto = new IpOrderRejectGoodsConfirmDto();
        confirmDto.setContactId(good.getClearingcorpcode());
        confirmDto.setOrderNo(good.getOrdernum());
        confirmDto.setTotalAmount(totalAmount);
        String jsonStr= JSONObject.fromObject(confirmDto).toString();
        orderRejectSender.send("rejected.payment.info",jsonStr);
    }
    /**
    * 修改
    * @Param:  * @param goods
    * @return: int
    */
    @Override
    public int updateGoodsReceiverList(List<IpOrderReceiveGoodDto> goods){

        return ipcOrderAllgoodsMapper.updateGoodsReceiverList(goods);
    }


    /** 
    * 查询个人地址
    * @Param:  * @param orderAddressDto 
    * @return: com.github.pagehelper.PageInfo<com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo>
    * @Author: zhangjie 
    * @Date: 2019/10/22 16:38
    */
    @Override
    public PageInfo<IpCustOrderAddressVo> getCustAddress(IpOrderAddressDto orderAddressDto){
        PageInfo<IpCustOrderAddressVo> pageInfo =custAddressService.getCustAddress(orderAddressDto);
        return pageInfo;
    }


    /**
     * 订单支付状态
     * @Param:  * @param orderPaymentResultDto
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/23 19:22
     */
    @Override
    public void  updateOrderPayemntResult(OrderPaymentResultDto orderPaymentResultDto){
        ipcOrderAllgoodsMapper.updateStatusByOrderNum(orderPaymentResultDto);
    }

    /**
    * 扣减商品库存
    * @Param:  * @param goodsId
     * @param goodsAmount
    * @return: void
    * @Author: zhangjie
    * @Date: 2019/10/28 13:36
    */
    @Override
    public void  deductionGoodsStock(String goodsId,String goodsType,
                                     String goodsAmount,String type,String attrId) throws Exception{
        IpGoodsStockDto ipGoodsStockDto=new IpGoodsStockDto();
        ipGoodsStockDto.setGoodsAmount(goodsAmount);
        ipGoodsStockDto.setGoodsId(goodsId);
        ipGoodsStockDto.setAttrId(attrId);
        ipGoodsStockDto.setType(type);
        ipGoodsStockDto.setGoodsType(goodsType);
        String jsonStr=JSONObject.fromObject(ipGoodsStockDto).toString();

        goodsSender.send("deduct.goods.stock",jsonStr);
    }

    /***
    * 根据订单商品id获取订单商品详情
    * @Param:  * @param orderGoodsId
    * @return: com.ekingwin.bas.cloud.entity.IpcOrderAllgoods
    * @Author: zhangjie
    * @Date: 2019/10/30 18:45
    */
    @Override
    public IpcOrderAllgoods getOrderGoods(String orderGoodsId){
        long parseLong = Long.parseLong(orderGoodsId);
        IpcOrderAllgoods ipcOrderAllgoods = ipcOrderAllgoodsMapper.selectByPrimaryKey(parseLong);
        return ipcOrderAllgoods;
    }
}
