package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.ProIpOrdersMapper;
import com.ekingwin.bas.cloud.dto.ProIpOrdersDto;
import com.ekingwin.bas.cloud.entity.ProIpOrders;
import com.ekingwin.bas.cloud.process.dto.CreateProcessDto;
import com.ekingwin.bas.cloud.process.service.IpcProcessService;
import com.ekingwin.bas.cloud.service.ProIpOrdersService;
import com.ekingwin.bas.cloud.util.MapObjUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


@Service
@Primary
public class ProIpOrdersServiceImpl  implements ProIpOrdersService{
    @Autowired
    private ProIpOrdersMapper proIpOrdersMapper;

    @Autowired
    @Qualifier(value="ipcProcessServiceImpl")
    private IpcProcessService ipcProcessService;

    @Override
    public String save(ProIpOrdersDto proIpOrdersDto) throws  Exception{
        ProIpOrders proIpOrders = new ProIpOrders();
        proIpOrdersDto.setApplicationtime(new Date());
        MapObjUtil.copy(proIpOrdersDto,proIpOrders);
        int id =proIpOrdersMapper.insert(proIpOrders);
        id=proIpOrders.getId();
        if(id>0){
            //保存成功之后调用发起流程的接口
            CreateProcessDto createProcessDto = new CreateProcessDto();
            createProcessDto.setUserId(proIpOrdersDto.getApplicationnumber());
            createProcessDto.setProcessName("DXDSQLC");//
            Map map = new HashMap<>();
            map.put("GYSJS",proIpOrdersDto.getSuppliercode());
            createProcessDto.setBusinessData(map);

            createProcessDto.setSubject(proIpOrders.getTheme());//主题
            String instanceId = ipcProcessService.createProcess(createProcessDto);
            proIpOrders.setInstanceid(instanceId);
            proIpOrdersMapper.updateByPrimaryKey(proIpOrders);
            return  id+"";
        }else{
            return "";
        }
    }

    @Override
    public ProIpOrdersDto selectByInstanceId(String instanceid) throws Exception {
        ProIpOrdersDto proIpOrdersDto = new ProIpOrdersDto();
        ProIpOrders proIpOrders =proIpOrdersMapper.selectByInstanceId(instanceid);
        MapObjUtil.copy(proIpOrders,proIpOrdersDto);
        return proIpOrdersDto;
    }
}