package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @program: rcworkspace
 * @description: 商品合同信息
 * @author: zhangjie
 * @create: 2019-06-30 11:32
 **/
@Data
@ApiModel("商品合同信息")
public class IpGoodsContractVo {

    @ApiModelProperty(value = "合同编码",required = false)
    private String code;

    @ApiModelProperty(value = "合同名称",required = false)
    private  String name;

    @ApiModelProperty(value = "合同总金额",required = false)
    private BigDecimal totalamount;

    @ApiModelProperty(value = "项目名称",required = false)
    private String projectName;


    @ApiModelProperty(value = "项目编号",required = false)
    private String projectCode;


    @ApiModelProperty(value = "签订公司编码",required = false)
    private String signcompanycode;

    @ApiModelProperty(value = "签订公司名称",required = false)
    private String signcompanyname;

    @ApiModelProperty(value = "商票比例",required = false)
    private String proportion;

    @ApiModelProperty(value = "补偿利息",required = false)
    private String compensation;

    @ApiModelProperty(value = "供应商编码",required = false)
    private String suppliercode;

    @ApiModelProperty(value = "供应商名称",required = false)
    private String suppliername;

    @ApiModelProperty(value = "生效日期",required = false)
    private String effectivedate;

    @ApiModelProperty(value = "截止日期",required = false)
    private String expirationdate;

    @ApiModelProperty(value = "商票单价（含税）",required = false)
    private BigDecimal tickettaxprice;

    @ApiModelProperty(value = "商票单价（不含税）",required = false)
    private  BigDecimal ticketnotaxprice;

    @ApiModelProperty(value = "是否商品支付",required = false)
    private  String isticket;

    @ApiModelProperty(value = "商票原价（含税）")
    private BigDecimal originalPrice;

    @ApiModelProperty(value = "商票原价不含税")
    private BigDecimal nooriginalPrice;



}
