package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author yuzm
 * @date 2019/10/12 10:40
 */
@Data
@ApiModel("采购协议列表")
public class IpGroupBuyingListVo {

    @ApiModelProperty(value = "主表主键id")
    private Integer id;

    @ApiModelProperty(value = "协议系统编号")
    private String contractId;

    @ApiModelProperty(value = "协议名称")
    private String contName;

    @ApiModelProperty(value = "协议类别")
    private String contType3;

    @ApiModelProperty(value = "协议类别描述")
    private String contType3Name;

    @ApiModelProperty(value = "采购方式")
    private String procType;

    @ApiModelProperty(value = "采购方式描述")
    private String procTypeName;

    @ApiModelProperty(value = "协议归档编号")
    private String contArchId;

    @ApiModelProperty(value = "归档日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date archiveDate;

    @ApiModelProperty(value = "协议状态")
    private String status;

    @ApiModelProperty(value = "协议状态描述")
    private String statusName;
}
