package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: IpInvoiceDetailVo
 * @Author: liujunfeng
 * @Date: 2019/12/10 16:17
 * @description:
 */
@Data
@ApiModel(value = "供应商发票记录详情")
public class IpInvoiceDetailVo {

    @ApiModelProperty(value = "订单对账ID",required = false)
    private String id;

    @ApiModelProperty(value = "商品编码",required = false)
    private String goodsId;

    @ApiModelProperty(value = "商品名称",required = false)
    private String goodsName;

    @ApiModelProperty(value = "开票商品名称",required = false)
    private String billGoodsName;

    @ApiModelProperty(value = "开票规格型号",required = false)
    private String billSpecifiModel;

    @ApiModelProperty(value = "税收分类编码",required = false)
    private String taxTypeCode;

    @ApiModelProperty(value = "单位",required = false)
    private String unit;

    @ApiModelProperty(value = "税率",required = false)
    private String rate;

    @ApiModelProperty(value = "已收货数量",required = false)
    private String receivedGoodsNo;

    @ApiModelProperty(value = "已开票数量",required = false)
    private String receivedBillNo;

    @ApiModelProperty(value = "不含税金额(上浮价)",required = false)
    private String notaxPriceFloat;

    @ApiModelProperty(value = "税额(上浮价)",required = false)
    private String taxFloat;

    @ApiModelProperty(value = "含税金额(上浮价)",required = false)
    private String priceFloat;

    @ApiModelProperty(value = "不含税金额(供应商价)",required = false)
    private String notaxPriceSupplier;

    @ApiModelProperty(value = "税额(供应商价)",required = false)
    private String taxSupplier;

    @ApiModelProperty(value = "含税金额(供应商价)",required = false)
    private String priceSupplier;





    @ApiModelProperty(value = "已开票金额",required = false)
    private String invoiceprice;

    @ApiModelProperty(value = "合同数量",required = false)
    private String contractNum;

    @ApiModelProperty(value = "合同金额(含税供应商价)",required = false)
    private String contractTaxPriceSupplier;

    @ApiModelProperty(value = "合同金额(不含税供应商价)",required = false)
    private String contractNoTaxPriceSupplier;







}
