package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: IpInvoiceLsitVo
 * @Author: liujunfeng
 * @Date: 2019/11/21 18:08
 * @description:
 */
@Data
@ApiModel("发票记录文件导出")
public class IpInvoiceLsitExcelVo {

    @ApiModelProperty(value = "发票号")
    private String invoiceNo;

    @ApiModelProperty(value = "合同编码")
    private String goodsContractId;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "发票合计金额")
    private String totalInvoicePrice;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private String applyForDate;

    @ApiModelProperty(value = "状态")
    private String states;

}
