package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@ApiModel("公告")
public class IpNoticeVo {
    @ApiModelProperty(value = "序号",required = false)
    private Long id;
    @ApiModelProperty(value = "公告主题",required = false)
    private String subject;
    @ApiModelProperty(value = "发布人",required = false)
    private String userid;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty(value = "发布时间",required = false)
    private Date publishertime;
    @ApiModelProperty(value = "备用字段",required = false)
    private String attribute;
    @ApiModelProperty(value = "公告详情",required = false)
    private String details;
    @ApiModelProperty(value = "公告权限",required = false)
    private String jurisdiction;
    @ApiModelProperty(value = "发布人姓名",required = false)
    private String username;
}
