package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-05 11:25
 **/
@Data
@ApiModel("发货单信息")
public class IpOrderDeliverVo {

    @ApiModelProperty(value = "发货单ID", required = false)
    private Long id;

    @ApiModelProperty(value = "收货人", required = false)
    private String consignee;

    @ApiModelProperty(value = "收货人工号", required = false)
    private String consigneeCode;

    @ApiModelProperty(value = "电话", required = false)
    private String phone;

    @ApiModelProperty(value = "收货地址", required = false)
    private String address;

    @ApiModelProperty(value = "物流公司", required = false)
    private String logisticsCompany;

    @ApiModelProperty(value = "物流公司编码",required = false)
    private String logisticsCompanyCode;

    @ApiModelProperty(value = "物流单号", required = false)
    private String logisticsNum;

    @ApiModelProperty(value = "送货单号", required = false)
    private String deliverNum;

    @ApiModelProperty(value = "发货时间", required = false)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty(value = "项目编号", required = false)
    private String projectCode;

    @ApiModelProperty(value = "项目名称", required = false)
    private String projectName;

    @ApiModelProperty(value = "分期名称", required = false)
    private String stagesName;

    @ApiModelProperty(value = "分期标识", required = false)
    private String stagesCode;

    @ApiModelProperty(value = "订单编号", required = false)
    private String ordernum;

    @ApiModelProperty(value = "商品信息", required = false)
    private List<IpOrderDeliverGoodVo> goods;

    @ApiModelProperty(value = "供应商信息", required = false)
    private String supplier;

    @ApiModelProperty(value = "供应商联系人信息", required = false)
    private String contact;

    @ApiModelProperty(value = "供应商联系人电话", required = false)
    private String contactPhone;


    @ApiModelProperty(value = "物流信息", required = false)
    private List<IpDeliverLogisticsVo> logistics;

    @ApiModelProperty(value = "收货人信息", required = false)
    private String receiverCodes;

    @ApiModelProperty(value = "收货人信息", required = false)
    private String receiverNames;

    @ApiModelProperty(value = "项目负责人",required = false)
    private String projectLeader;

    @ApiModelProperty(value = "项目负责人工号",required = false)
    private String projectLeaderCode;

    @ApiModelProperty(value = "监理工号",required = false)
    private String supervisorCode;

    @ApiModelProperty(value = "监理姓名",required = false)
    private String supervisorName;

    @ApiModelProperty(value = "状态",required = false)
    private String status;

    @ApiModelProperty(value = "流程实例号",required = false)
    private String instid;

    @ApiModelProperty(value = "收货单权限",required = false)
    private String receiverCodeNum;

    @ApiModelProperty(value = "订单发起人",required = false)
    private String inputperson;

    @ApiModelProperty(value = "供应商工号",required = false)
    private String supplieraccount;

    @ApiModelProperty(value = "订单类型",required = false)
    private String orderType;
}
