package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-30 17:57
 **/
@Data
@ApiModel("购物车商品信息")
public class IpOrderGoodsDetailVo {


    @ApiModelProperty(value = "主键",required = false)
    private  Long id;

    @ApiModelProperty(value = "用户ID",required = false)
    private  String userId;

    @ApiModelProperty(value = "商品ID",required = false)
    private  Long goodsid;

    @ApiModelProperty(value = "数量",required = false)
    private  BigDecimal count;

    @ApiModelProperty(value = "含税价格",required = false)
    private BigDecimal price;

    @ApiModelProperty(value = "不含税价格",required = false)
    private BigDecimal bhsprice;

    @ApiModelProperty(value = "含税价格",required = false)
    private BigDecimal hsprice;

    @ApiModelProperty(value = "税率",required = false)
    private String taxrate;

    @ApiModelProperty(value = "货币币种",required = false)
    private  String currency;

    @ApiModelProperty(value = "图片" ,required = false)
    private  String urlid;

    @ApiModelProperty(value = "图片路径" ,required = false)
    private String urlPath;

    @ApiModelProperty(value = "价格类型" ,required = false)
    private  String pricetype;


    @ApiModelProperty(value = "含税总价" ,required = false)
    private BigDecimal goodstotalhsprice;

    @ApiModelProperty(value = "不含税总价" ,required = false)
    private BigDecimal goodstotalbhsprice;

    @ApiModelProperty(value = "品牌" ,required = false)
    private  String brand;

    @ApiModelProperty(value = "商品名称" ,required = false)
    private  String goodsname;

    @ApiModelProperty(value = "商品编码" ,required = false)
    private  String goodsnum;

    @ApiModelProperty(value = "单位" ,required = false)
    private  String unit;

    @ApiModelProperty(value = "库存" ,required = false)
    private  long stock;

    @ApiModelProperty(value = "一级分类" ,required = false)
    private  String ftnpfirstcategorycode;
    private  String ftnpfirstcategoryname;

    @ApiModelProperty(value = "二级分类" ,required = false)
    private  String ftnpsecondcategorycode;
    private  String ftnpsecondcategoryname;

    @ApiModelProperty(value = "三级分类" ,required = false)
    private  String ftnpthreecategorycode;
    private  String ftnpthreecategoryname;

    @ApiModelProperty(value = "税收分类编码" ,required = false)
    private  String taxtypecode;
    @ApiModelProperty(value = "开票商品名称" ,required = false)
    private  String billgoodsname;
    @ApiModelProperty(value = "开票规格型号" ,required = false)
    private  String billtypecode;
    @ApiModelProperty(value = "材质" ,required = false)
    private  String material;
    @ApiModelProperty(value = "产地" ,required = false)
    private  String proaddr;
    @ApiModelProperty(value = "保修年限" ,required = false)
    private  String guarantee;

    @ApiModelProperty(value = "单位名称" ,required = false)
    private  String unitName;

    @ApiModelProperty(value = "授权商" ,required = false)
    private  String  supplierid;

    @ApiModelProperty(value = "授权商" ,required = false)
    private  String  supplier;

    @ApiModelProperty(value = "最少购买量" ,required = false)
    private  String minimumquantity;

    @ApiModelProperty(value = "规格型号" ,required = false)
    private  String ftnpspecificationsmodel;

    @ApiModelProperty(value = "合同名称" ,required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编号" ,required = false)
    private String contractCode;

    @ApiModelProperty(value = "商票比例" ,required = false)
    private String proportion;

    @ApiModelProperty(value = "补偿利息" ,required = false)
    private String compensation;


    @ApiModelProperty(value = "支付方式" ,required = false)
    private String paymentMethod;

    @ApiModelProperty(value = "支付方式编码" ,required = false)
    private String paymentMethodCode;

    @ApiModelProperty(value = "运费" ,required = false)
    private String freight;

    @ApiModelProperty(value = "总运费" ,required = false)
    private  String goodsTotalFregin;

    @ApiModelProperty(value = "商票单价（含税）",required = false)
    private BigDecimal tickettaxprice;

    @ApiModelProperty(value = "商票单价（不含税）",required = false)
    private  BigDecimal ticketnotaxprice;

    @ApiModelProperty(value = "商票总价（含税）",required = false)
    private String ticketpricetotal;

    @ApiModelProperty(value = "商票总价（不含税）",required = false)
    private  String noticketpricetotal;


    @ApiModelProperty(value = "是否商票支付",required = false)
    private String isticket;

    @ApiModelProperty(value = "状态",required = false)
    private String  state;

    @ApiModelProperty(value = "子订单单号",required = false)
    private String orderNumChild;

    @ApiModelProperty(value = "主单号",required = false)
    private String ordernum;

    @ApiModelProperty(value = "已收货数量",required = false)
    private BigDecimal goodsReceived;

    @ApiModelProperty(value = "已发货数量",required = false)
    private BigDecimal goodsDeliver;

    @ApiModelProperty(value = "收货人工号",required = false)
    private String receivedNum;

    @ApiModelProperty(value = "供货方式",required = false)
    private String  supportType;

    @ApiModelProperty(value = "供货编号",required = false)
    private String  supportCode;

    @ApiModelProperty(value = "待收货数量",required = false)
    private BigDecimal confirmedReceiptNum;

    @ApiModelProperty(value = "供应商原价含税价格",required = false)
    private  BigDecimal rmbhsprice;

    @ApiModelProperty(value = "供应商原价不含税价格",required = false)
    private  BigDecimal rmbbhsprice;

    @ApiModelProperty(value = "供应商邮箱",required = false)
    private String email;

    @ApiModelProperty(value = "商品类型 常规 CG 活动 HD PM 拍卖",required = false)
    private String ftnpconfiguration;


    @ApiModelProperty(value = "商品类型 常规 CG 活动 HD PM 拍卖")
    private String category;

    @ApiModelProperty(value = "市场价格")
    private String freightprice;

    @ApiModelProperty(value = "结算公司")
    private String clearingcorp;

    @ApiModelProperty(value = "结算公司标识")
    private String clearingcorpcode;

    @ApiModelProperty(value = "销售区域")
    private String salesarea;


    @ApiModelProperty(value = "销售区域名称")
    private String salesareaname;


    @ApiModelProperty(value = "是否评价")
    private String isevaluate;

    @ApiModelProperty(value = "带评价的状态")
    private String statestr;

    @ApiModelProperty(value = "综合评分")
    private String comprehensiveScore;

    @ApiModelProperty(value = "商品质量")
    private String goodsData;

    @ApiModelProperty(value = "物流效率")
    private String logisticsEfficiency;

    @ApiModelProperty(value = "问题描述")
    private String problemDescribe;

    @ApiModelProperty(value = "问题图片")
    private String pictureUrl;

    @ApiModelProperty(value = "发票邮箱")
    private String invoiceEmail;

    @ApiModelProperty(value = "物料颜色")
    private String speciColor;

    @ApiModelProperty(value = "型号")
    private String speciModel;

    @ApiModelProperty(value = "尺寸")
    private String speciSize;

    @ApiModelProperty(value = "其他")
    private String speciOther;

    @ApiModelProperty(value = "属性组合价格ID")
    private String attrid;

    @ApiModelProperty(value = "区分商品类型")
    private String ftnpjc;

    @ApiModelProperty(value = "原价含税)总价(实付)")
    private String goodsrmbtotalhsprice;

    @ApiModelProperty(value = "原价（不含税)总价(实付)")
    private String goodsrmbtotalbhsprice;
}
