package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-10 16:17
 **/
@Data
@ApiModel("收货单详情")
public class IpOrderReceiverVo {

    @ApiModelProperty(value = "供应商信息", required = false)
    private String supplier;

    @ApiModelProperty(value = "供应商联系人信息", required = false)
    private String contact;

    @ApiModelProperty(value = "供应商联系人电话", required = false)
    private String contactPhone;

    @ApiModelProperty(value = "发起方", required = false)
    private String createName;

    @ApiModelProperty(value = "发起方工号", required = false)
    private String createId;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty(value = "发起时间", required = false)
    private Date createTime;

    @ApiModelProperty(value = "收货单状态", required = false)
    private String status;

    @ApiModelProperty(value = "收货单商品信息", required = false)
    private  List<IpOrderReceiverGoodVo> goods;

    @ApiModelProperty(value = "项目编号", required = false)
    private String projectCode;

    @ApiModelProperty(value = "项目名称", required = false)
    private String projectName;

    @ApiModelProperty(value = "分期名称", required = false)
    private String stagesName;

    @ApiModelProperty(value = "分期编号", required = false)
    private String stagesCode;

    @ApiModelProperty(value = "收货地址", required = false)
    private String address;

    @ApiModelProperty(value = "发货单号", required = false)
    private String deliverNum;

    @ApiModelProperty(value = "收货人", required = false)
    private String consignee;

    @ApiModelProperty(value = "收货人工号", required = false)
    private String consigneeCode;

    @ApiModelProperty(value = "电话", required = false)
    private String phone;

    @ApiModelProperty(value = "项目负责人")
    private String projectLeader;

    @ApiModelProperty(value = "项目负责人")
    private String projectLeaderCode;


    @ApiModelProperty(value = "项目负责人")
    private String supervisorCode;

    @ApiModelProperty(value = "项目负责人")
    private String supervisorName;

    @ApiModelProperty(value = "收货方")
    private String receiverNames;

    @ApiModelProperty(value = "收货方")
    private String receiverCodes;
}
