package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: IpOrderReconciliationProjectExcelVo
 * @Author: liujunfeng
 * @Date: 2020/1/10 10:34
 * @description:
 */
@Data
@ApiModel("项目对账单列表导出")
public class IpOrderReconciliationProjectExcelVo {

    @ApiModelProperty(value = "账单号", required = false)
    private String billNumber;

    @ApiModelProperty(value = "生成日期", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty(value = "订单号", required = false)
    private String orderNum;

    @ApiModelProperty(value = "项目名称", required = false)
    private String projectName;

    @ApiModelProperty(value = "分期", required = false ,hidden = true)
    private String installmentName;

    @ApiModelProperty(value = "合同名称", required = false)
    private String contractName;

    @ApiModelProperty(value = "订单总额", required = false)
    private BigDecimal orderTotalPrice;

    @ApiModelProperty(value = "下单人", required = false)
    private String orderPersion;

    @ApiModelProperty(value = "下单时间", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date orderTime;

    @ApiModelProperty(value = "商品编码", required = false)
    private String goodsnum;

    @ApiModelProperty(value = "商品名称", required = false)
    private String goodsName;

    @ApiModelProperty(value = "开票商品名称", required = false)
    private String billGoodsName;

    @ApiModelProperty(value = "开票规格型号", required = false)
    private String billSpecifiModel;

    @ApiModelProperty(value = "价格类型", required = false)
    private String priceType;

    @ApiModelProperty(value = "税收分类编码", required = false)
    private String taxTypeCode;

    @ApiModelProperty(value = "品牌", required = false)
    private String brand;

    @ApiModelProperty(value = "一级分类", required = false)
    private String ftnpfirstcategoryname;

    @ApiModelProperty(value = "二级分类", required = false)
    private String ftnpsecondcategoryname;

    @ApiModelProperty(value = "三级分类", required = false)
    private String ftnpthreecategoryname;

    @ApiModelProperty(value = "税率", required = false)
    private String rate;

    @ApiModelProperty(value = "综合不含税单价", required = false)
    private BigDecimal notaxPrice;

    @ApiModelProperty(value = "综合含税单价", required = false)
    private BigDecimal price;

    @ApiModelProperty(value = "小计", required = false)
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "发货方", required = false)
    private String shipper;

    @ApiModelProperty(value = "运费", required = false)
    private BigDecimal freight;

    @ApiModelProperty(value = "订单数量", required = false)
    private String orderQuantity;

    @ApiModelProperty(value = "已收货数量", required = false)
    private Integer receivingNum;

    @ApiModelProperty(value = "未收货数量", required = false)
    private Integer notReceivingNum;

    @ApiModelProperty(value = "对账含税金额", required = false)
    private BigDecimal billTaxPrice;

    @ApiModelProperty(value = "状态", required = false)
    private BigDecimal orderStatus;

}
