package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-16 17:08
 **/
@Data
public class IpOrderRejectedVo {

    @ApiModelProperty(value = "退货单号")
    private String rejectCode;


    @ApiModelProperty(value = "退货单ID")
    private String rejectedId;

    @ApiModelProperty(value = "申请退货时间")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyDate;

    @ApiModelProperty(value = "订单ID")
    private String orderId;

    @ApiModelProperty(value = "订单编号")
    private String orderNum;


    @ApiModelProperty(value = "商品数据")
    private List<IpOrderRejectedGoodsVo> goodsList;


    private String createUser;

    private String createId;

    @ApiModelProperty(value = "物流单号")
    private String logisticsNumber;

    @ApiModelProperty(value = "快递公司")
    private String courierName;

    @ApiModelProperty(value = "快递公司编号")
    private String courierLogo;

    @ApiModelProperty(value = "物流信息", required = false)
    private List<IpDeliverLogisticsVo> logistics;
}
