package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @ClassName: IpPaymentApplyVo
 * @Author: liujunfeng
 * @Date: 2019/11/30 14:35
 * @description:  付款申请VO
 */
@Data
@ApiModel(value = "零星采购发票")
public class IpPaymentApplyVo {

    @ApiModelProperty(value = "对账单号",required = false)
    private String billNumber;

    @ApiModelProperty(value = "合同名称",required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编码",required = false)
    private String contractCode;

    @ApiModelProperty(value = "项目编号",required = false)
    private String projectCode;

    @ApiModelProperty(value = "项目名称",required = false)
    private String projectName;

    @ApiModelProperty(value = "分期编码",required = false)
    private String stageNo;

    @ApiModelProperty(value = "分期名称",required = false)
    private String stageName;

    @ApiModelProperty(value = "合同金额",required = false)
    private String contCny;

    @ApiModelProperty(value = "最新总价含税",required = false)
    private String newAmtTax;

    @ApiModelProperty(value = "最新总价不含税",required = false)
    private String newAmt;


    @ApiModelProperty(value = "累计应付金额",required = false)
    private String supplierTotalPrice;

    @ApiModelProperty(value = "累计实付金额",required = false)
    private String applyAmount;


    @ApiModelProperty(value = "累计收货金额",required = false)
    private String supplierTotalPriceBill;

    @ApiModelProperty(value = "累计开票金额",required = false)
    private String totalInvoicePriceOut;


    @ApiModelProperty(value = "付款申请",required = false)
    private List<IpPaymentDetailVo> paymentDetailVos;

    @ApiModelProperty(value = "发票记录",required = false)
    private List<IpInvoiceDetailVo> invoiceDetailVos;


}
