package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: IpPaymentContract
 * @Author: liujunfeng
 * @Date: 2019/11/30 15:53
 * @description:
 */
@Data
public class IpPaymentContractVo {

    @ApiModelProperty(value = "合同编码",required = false)
    private String contractId;

    @ApiModelProperty(value = "合同名称",required = false)
    private String contName;

    @ApiModelProperty(value = "是否商票支付(A.是,B.否)",required = false)
    private String salePrice;

    @ApiModelProperty(value = "商票比例",required = false)
    private String spRatio;

    @ApiModelProperty(value = "补偿利息",required = false)
    private String tpRatio;

    @ApiModelProperty(value = "合同金额",required = false)
    private String contCny;

    @ApiModelProperty(value = "生效时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private String fromDate;

    @ApiModelProperty(value = "所属项目编码",required = false)
    private String projectNo;

    @ApiModelProperty(value = "所属项目名称",required = false)
    private String projectName;

    @ApiModelProperty(value = "所属分期编码",required = false)
    private String stageNo;

    @ApiModelProperty(value = "所属分期名称",required = false)
    private String stageName;

    @ApiModelProperty(value = "供应商ID",required = true)
    private String partyB;

    @ApiModelProperty(value = "销售合同",required = false)
    private String goodsContractId;

    @ApiModelProperty(value = "销售合同名称",required = false)
    private String goodsContractName;

}
