package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: IpPaymentDetailVo
 * @Author: liujunfeng
 * @Date: 2019/12/10 16:17
 * @description:
 */
@Data
@ApiModel(value = "付款申请商品明细")
public class IpPaymentDetailVo {

    @ApiModelProperty(value = "订单对账ID",required = false)
    private String id;

    @ApiModelProperty(value = "商品编码",required = false)
    private String goodsId;

    @ApiModelProperty(value = "商品名称",required = false)
    private String goodsName;

    @ApiModelProperty(value = "税率",required = false)
    private String rate;

    @ApiModelProperty(value = "已收货数量",required = false)
    private String receivedGoodsNo;

    @ApiModelProperty(value = "已对账数量",required = false)
    private String checkeAmount;

    @ApiModelProperty(value = "进度款未支付数量",required = false)
    private String unpaidQuantity;

    @ApiModelProperty(value = "预付款未支付数量",required = false)
    private String contractQuantity;

    @ApiModelProperty(value = "不含税金额(上浮价)",required = false)
    private String notaxPriceFloat;

    @ApiModelProperty(value = "税额(上浮价)",required = false)
    private String taxFloat;

    @ApiModelProperty(value = "含税金额(上浮价)",required = false)
    private String priceFloat;

    @ApiModelProperty(value = "不含税金额(供应商价)",required = false)
    private String notaxPriceSupplier;

    @ApiModelProperty(value = "税额(供应商价)",required = false)
    private String taxSupplier;

    @ApiModelProperty(value = "含税金额(供应商价)",required = false)
    private String priceSupplier;


    @ApiModelProperty(value = "已付款金额",required = false)
    private String paymentprice;

    @ApiModelProperty(value = "合同数量",required = false)
    private String contractNum;

    @ApiModelProperty(value = "合同金额(含税上浮价)",required = false)
    private String contractTaxPriceFloat;

    @ApiModelProperty(value = "合同金额(不含税上浮价)",required = false)
    private String contractNoTaxPriceFloat;

    @ApiModelProperty(value = "合同金额(含税供应商价)",required = false)
    private String contractTaxPriceSupplier;

    @ApiModelProperty(value = "合同金额(不含税供应商价)",required = false)
    private String contractNoTaxPriceSupplier;

}
