package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel("付款申请表格导出")
public class IpPaymentExcelVo {

    @ApiModelProperty(value = "申请单号",required = false)
    private String applyForNum;

    @ApiModelProperty(value = "申请总额",required = false)
    private BigDecimal applyAmount;

    @ApiModelProperty(value = "申请时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyDate;

    @ApiModelProperty(value = "审定金额",required = false)
    private String authorizedAmount;

    @ApiModelProperty(value = "合同名称",required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编码",required = false)
    private String goodsContractId;

    @ApiModelProperty(value = "合同金额",required = false)
    private BigDecimal contractAmount;

    @ApiModelProperty(value = "状态",required = false)
    private String state;

}
