package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName: IpProjectContractGoodsListVo
 * @Author: liujunfeng
 * @Date: 2019/11/19 17:05
 * @description:
 */
@Data
@ApiModel("合同列表商品")
public class IpProjectContractGoodsListVo {

    private Integer id;
    private Integer contractid;
    private String goodscode;
    private String goodsname;
    private Integer categoryid;
    private String categoryname;
    private String brand;
    private String specifications;

    @ApiModelProperty(value = "原价不含税单价", required = false)
    private BigDecimal notaxprice;

    private Integer rate;

    @ApiModelProperty(value = "材料上浮价含税单价", required = false)
    private BigDecimal taxprice;

    private String unit;
    private BigDecimal contactornum;
    private BigDecimal noexecutenum;
    private BigDecimal executenum;
    private BigDecimal tickettaxprice;
    private BigDecimal ticketnotaxprice;

}
