package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName: InvoiceDetailDto
 * @Author: liujunfeng
 * @Date: 2019/11/24 17:50
 * @description:
 */
@Data
@ApiModel(value = "推送发票记录-发票明细")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class IpSapInvoiceDetailVo {

    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    @ApiModelProperty(value = "发票代码")
    private String invoiceCode;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "备用字段1")
    private String extend1;

    @ApiModelProperty(value = "备用字段2")
    private String extend2;



}
