package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName: InvoiceItemDto
 * @Author: liujunfeng
 * @Date: 2019/11/24 17:51
 * @description:
 */
@Data
@ApiModel(value = "推送发票记录-材料明细")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class IpSapInvoiceItemVo {


    @ApiModelProperty(value = "行项目")
    private String buzei;

    @ApiModelProperty(value = "供应品类")
    private String vendorType;

    @ApiModelProperty(value = "物料编码")
    private String goodsCode;

    @ApiModelProperty(value = "物料名称")
    private String goodsName;

    @ApiModelProperty(value = "规格型号")
    private String specification;

    @ApiModelProperty(value = "货币")
    private String waers;

    @ApiModelProperty(value = "单位")
    private String unit;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "本次开票数量")
    private BigDecimal quant;

    @ApiModelProperty(value = "已开票数量")
    private BigDecimal yfQuant;

    @ApiModelProperty(value = "累计收货数量")
    private BigDecimal totalQuant;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "金额(含税)")
    private BigDecimal amtIncltax;

    @ApiModelProperty(value = "金额(不含税)")
    private BigDecimal amtExcltax;

    @ApiModelProperty(value = "开票产品名称")
    private String billGoodsName;

    @ApiModelProperty(value = "开票规格型号")
    private String billTypeCode;

    @ApiModelProperty(value = "税收分类编码")
    private String taxTypeCode;

    @ApiModelProperty(value = "材料上浮价")
    private BigDecimal salePrice;

    @ApiModelProperty(value = "协议编号")
    private String protocoId;

    @ApiModelProperty(value = "备用字段1")
    private String extend1;

    @ApiModelProperty(value = "备用字段2")
    private String extend2;

}
