package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: InvoiceRecordDto
 * @Author: liujunfeng
 * @Date: 2019/11/24 17:19
 * @description:
 */
@Data
@ApiModel(value = "同步sap发票记录信息")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY,
        getterVisibility=JsonAutoDetect.Visibility.NONE)
public class IpSapInvoiceVo {

    @ApiModelProperty(value = "电商单据号")
    private String billNum;

    @ApiModelProperty(value = "单据类型")
    private String billType;

    @ApiModelProperty(value = "公司代码")
    private String companyCode;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "供应商编码")
    private String supplierCode;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "项目公司")
    private String projectCode;

    @ApiModelProperty(value = "项目公司名称")
    private String projectName;

    @ApiModelProperty(value = "分期编号")
    private String stageCode;

    @ApiModelProperty(value = "分期编码描述")
    private String stageName;

    @ApiModelProperty(value = "合同编号")
    private String contractCode;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "合同最新金额(含税)")
    private BigDecimal contractPrice;

    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal taxPrice;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "系统来源")
    private String systemSource;

    @ApiModelProperty(value = "电商单据类型")
    private String dstype;

    @ApiModelProperty(value = "对账单号")
    private String accStatement;

    @ApiModelProperty(value = "单字符标记")
    private String operation;

    @ApiModelProperty(value = "备用字段2")
    private String EXTEND2;

    @ApiModelProperty(value = "发票明细")
    List<IpSapInvoiceDetailVo> invoice;

    @ApiModelProperty(value = "材料明细")
    List<IpSapInvoiceItemVo> item;

}
