package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel("同步sap付款单明细信息")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class IpSapPaymentDetailVo {

    @ApiModelProperty(value = "商品编码",required = false)
    @JsonProperty(value = "goodsNum")
    private String goodsCode;

    @JsonProperty(value = "paymentNo")
    private String paymentNo;

    @ApiModelProperty(value = "单价（原价）")
    @JsonProperty(value = "price")
    private String price;
    @ApiModelProperty(value = "不含税单价（原价）")
    @JsonProperty(value = "priceNoTax")
    private String priceNoTax;
    @ApiModelProperty(value = "税额（原价）",required = false)
    @JsonProperty(value = "taxAmt")
    private BigDecimal rateGoods;
    @ApiModelProperty(value = "金额(含税)（原价）",required = false)
    @JsonProperty(value = "totalPrice")
    private BigDecimal taxAmountGoods;
    @ApiModelProperty(value = "金额(不含税)（原价）",required = false)
    @JsonProperty(value = "totalPriceNoTax")
    private BigDecimal noTaxAmountGoods;



    @ApiModelProperty(value = "单价（上浮价）")
    @JsonProperty(value = "salePrice")
    private String salePrice;
    @ApiModelProperty(value = "不含税单价（上浮价）")
    @JsonProperty(value = "salePriceNoTax")
    private String salePriceNoTax;
    @ApiModelProperty(value = "税额（上浮价）",required = false)
    @JsonProperty(value = "taxAmtf")
    private BigDecimal taxAmtf;
    @ApiModelProperty(value = "金额(含税)（上浮价）",required = false)
    @JsonProperty(value = "amtSalePrice")
    private BigDecimal amtSalePrice;
    @ApiModelProperty(value = "金额(不含税)（上浮价）",required = false)
    @JsonProperty(value = "amtSalePriceNoTax")
    private BigDecimal amtSalePriceNoTax;



    @ApiModelProperty(value = "数量",required = false)
    @JsonProperty(value = "account")
    private String applyNum;

    @ApiModelProperty(value = "税率",required = false)
    @JsonProperty(value = "taxRate")
    private String rate;


}
