package com.ekingwin.bas.cloud.vo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 *             ObjectMapper mapper = new ObjectMapper();
 *             //格式化输出
 *             mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
 *             //键按自然顺序输出
 *             mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
 *              String  requestJson = mapper.writeValueAsString(updateDataOwner);
 */
@Data
@ApiModel("同步sap付款单信息")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY,
        getterVisibility=JsonAutoDetect.Visibility.NONE)
public class IpSapPaymentVo {


    @ApiModelProperty(value = "申请单号",required = false)
    @JsonProperty(value = "paymentNo")
    private String applyForNum;

    @ApiModelProperty(value = "付款类型",required = false)
    @JsonProperty(value = "paymentType")
    private String paymentTypes;

    @ApiModelProperty(value = "合同编码",required = false)
    @JsonProperty(value = "contractId")
    private String goodsContractId;

    @ApiModelProperty(value = "银行账号",required = false)
    @JsonProperty(value = "bankAccount")
    private String bankNum;

    @ApiModelProperty(value = "开户行",required = false)
    @JsonProperty(value = "bankName")
    private String openBank;


    @ApiModelProperty(value = "申请金额(原价)",required = false)
    @JsonProperty(value = "paymentPrice")
    private BigDecimal applyAmount;

    @JsonProperty(value = "paymentSalePrice")
    @ApiModelProperty(value = "申请金额(上浮价)",required = false)
    private BigDecimal paymentSalePrice;


    @ApiModelProperty(value = "备注",required = false)
    @JsonProperty(value = "remark")
    private String remark;

    @ApiModelProperty(value = "计划收款月份",required = false)
    @JsonFormat(pattern = "yyyyMM",timezone = "GMT+8")
    @JsonProperty(value = "paymentMonth")
    private Date planMonth;

    @JsonProperty(value = "eceivingUnitCode")
    private String supplierid;

    @JsonProperty(value = "paymentStatus")
    private String paymentStatus="13";

    @JsonProperty(value = "source")
    private String source="电商平台";

    @JsonProperty(value = "waers")
    private String waers="CNY";


    @JsonProperty(value = "paymentProjects")
    private List<IpSapPaymentDetailVo> paymentProjects;


    @JsonProperty(value = "attInfos")
    private List<IpSapPaymentAttmentVo> ipSapPaymentAttmentVos;

}
