package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpGroupBuyingDetailDto;
import com.ekingwin.bas.cloud.dto.IpGroupBuyingManagerDto;
import com.ekingwin.bas.cloud.service.IpGroupBuyingManagerService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpGroupBuyingSearchDataVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program:
 * @description:
 * @author: yuzm
 * @create: 2019-10-12 10:17
 **/
@RestController
@RequestMapping(value = "/groupBuying/")
@Api(tags = "采购协议管理", description = "采购协议管理", value = "采购协议管理")
public class GroupBuyingManagerController {

    @Autowired
    private IpGroupBuyingManagerService ipGroupBuyingManagerService;

    @ApiOperation(value = "查询采购协议列表", notes = "查询采购协议列表")
    @PostMapping(value = "/selectGroupBuyingList")
    public Result selectGroupBuyingList(@RequestBody IpGroupBuyingManagerDto ipGroupBuyingManagerDto) throws Exception{
        PageInfo pageInfo = ipGroupBuyingManagerService.selectGroupBuyingList(ipGroupBuyingManagerDto);
        return Result.ok(pageInfo);
    }

    @ApiOperation(value = "查询采购协议详情", notes = "查询采购协议详情")
    @PostMapping(value = "/selectGroupBuyingDetail")
    public Result selectGroupBuyingDetail(@RequestBody IpGroupBuyingDetailDto ipGroupBuyingDetailDto ) throws Exception{
        IpGroupBuyingSearchDataVo ipGroupBuyingSearchDataVo = ipGroupBuyingManagerService.selectGroupBuyingDetail(ipGroupBuyingDetailDto);
        return Result.ok(ipGroupBuyingSearchDataVo);
    }

}
