package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpCarSearchDto;
import com.ekingwin.bas.cloud.dto.IpCarUpdateDto;
import com.ekingwin.bas.cloud.dto.IpCartDeleteDto;
import com.ekingwin.bas.cloud.dto.IpcCartDto;
import com.ekingwin.bas.cloud.service.IpcCartService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpCarDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-19 16:26
 **/
@RestController
@RequestMapping(value = "/car/")
@Api(tags = "购物车", description = "购物车", value = "购物车")
public class IpCarController {

    @Autowired
    private IpcCartService ipcCartService;



    @PostMapping("/getCarCount")
    @ApiOperation(value = "获取购物车商品数量", notes = "获取购物车商品数量")
    public Result getCarCount(@RequestBody IpCarSearchDto ipCarSearchDto){
        int count=ipcCartService.getCarCount(ipCarSearchDto);
        return Result.ok(count);
    }


    @PostMapping("/saveCar")
    @ApiOperation(value = "加入购物车", notes = "加入购物车")
    public Result saveCar(@RequestBody IpcCartDto ipcCartDto) throws Exception{
        ipcCartService.saveCar(ipcCartDto);
        return Result.ok();
    }

    @PostMapping("/getCarGoodsList")
    @ApiOperation(value = "查询购物车表", notes = "查询购物车列表",response = IpCarDetailVo.class )
    public Result getCarGoodsList(@RequestBody IpCarSearchDto ipCarSearchDto) throws Exception{
        List<IpCarDetailVo>  pageInfo=ipcCartService.getCarGoodsList(ipCarSearchDto);
        return Result.ok(pageInfo);
    }
    @PostMapping("/deleCar")
    @ApiOperation(value = "清空购物车", notes = "清空购物车")
    public Result deleCar(@RequestBody IpCartDeleteDto ipcCartDto) throws Exception{
        ipcCartService.deleCar(ipcCartDto);
        return Result.ok();
    }

    @PostMapping("/updateCar")
    @ApiOperation(value = "修改购物车", notes = "修改购物车")
    public Result updateCar(@RequestBody IpCarUpdateDto ipCarUpdateDto) throws Exception{
        ipcCartService.updateCar(ipCarUpdateDto);
        return Result.ok();
    }




}
