package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpCustAddressDefaultDto;
import com.ekingwin.bas.cloud.dto.IpCustAddressDto;
import com.ekingwin.bas.cloud.service.IpCustAddressService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-25 15:15
 **/
@RestController
@RequestMapping(value = "/custAddressr/")
@Api(tags = "用户地址管理", description = "用户地址管理", value = "用户地址管理")
public class IpCustAddressController {


    @Autowired
    private IpCustAddressService custAddressService;


    @PostMapping("/saveCustAdderss")
    @ApiOperation(value = "新建地址", notes = "新建地址")
    public Result saveCustAdderss(@RequestBody IpCustAddressDto ipCustAddressDto) throws Exception{
        custAddressService.saveCustAdderss(ipCustAddressDto);
        return Result.ok();
    }


    @PostMapping("/deleteCustAddress/{id}")
    @ApiOperation(value = "删除地址", notes = "删除地址")
    public Result deleteCustAddress(@PathVariable(value = "id") long id) throws Exception{
        custAddressService.deleteCustAddress(id);
        return Result.ok();
    }

    @PostMapping("/defaultCustAddress")
    @ApiOperation(value = "设置默认地址", notes = "设置默认地址")
    public Result defaultCustAddress(@RequestBody IpCustAddressDefaultDto addressDefaultDto) throws Exception{
        custAddressService.defaultCustAddress(addressDefaultDto.getId(),addressDefaultDto.getUserid());
        return Result.ok();
    }

    @PostMapping("/getDefaultCustAddress")
    @ApiOperation(value = "获取默认地址", notes = "获取默认地址",response = IpCustOrderAddressVo.class)
    public Result getDefaultCustAddress(@RequestBody IpCustAddressDefaultDto addressDefaultDto) throws Exception{
        IpCustOrderAddressVo custAddress = custAddressService.getCustAddress(addressDefaultDto.getUserid());
        return Result.ok(custAddress);
    }


}
