package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpGoodsContractDto;
import com.ekingwin.bas.cloud.service.IpGoodsContractService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpGoodsContractVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-29 17:38
 **/
@RestController
@RequestMapping(value = "/goodscontract/")
@Api(tags = "商品合同信息", description = "商品合同信息", value = "商品合同信息")
public class IpGoodsContractController {

    @Autowired
    private IpGoodsContractService ipGoodsContractService;


    @PostMapping("/getGoodsContract")
    @ApiOperation(value = "获取商品合同信息", notes = "获取商品合同信息",response = IpGoodsContractVo.class)
    public Result getAllProject(@RequestBody IpGoodsContractDto ipGoodsContractDto){
        PageInfo pageInfo=ipGoodsContractService.selectGoodContract(ipGoodsContractDto);
        return Result.ok(pageInfo);
    }
}
