package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpInvoiceDto;
import com.ekingwin.bas.cloud.dto.IpInvoicePageDto;
import com.ekingwin.bas.cloud.dto.IpPurchasesDto;
import com.ekingwin.bas.cloud.service.IpInvoiceService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpInvoiceLsitVo;
import com.ekingwin.bas.cloud.vo.IpPaymentApplyVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @ClassName: IpInvoiceController
 * @Author: liujunfeng
 * @Date: 2019/11/21 17:20
 * @description:
 */
@RestController
@RequestMapping("/invoice/")
@Api(tags = "发票记录", description = "发票记录", value = "发票记录")
public class IpInvoiceController {

    @Autowired
    IpInvoiceService invoiceService;


    @PostMapping("/getInvoiceLsit")
    @ApiOperation(value = "发票记录列表", notes = "发票记录列表",response = IpInvoiceLsitVo.class)
    public Result getInvoiceLsit(@RequestBody IpInvoicePageDto invoicePageDto) throws Exception {
        PageInfo pageInfo = invoiceService.getInvoiceLsit(invoicePageDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/getInvoice")
    @ApiOperation(value = "发票记录详情", notes = "发票记录详情",response = IpInvoiceDto.class)
    public Result getInvoice(@RequestBody IpInvoicePageDto invoicePageDto) throws Exception {
        IpInvoiceDto invoiceDto = invoiceService.getInvoice(invoicePageDto);
        return Result.ok(invoiceDto);
    }

    @PostMapping("/saveInvoice")
    @ApiOperation(value = "新增发票记录", notes = "新增发票记录")
    public Result saveInvoice(@RequestBody IpInvoiceDto invoiceDto) throws Exception {
        String results = invoiceService.saveInvoice(invoiceDto);
        return Result.ok(results);
    }

    @PostMapping("/getRetailPurchasesList")
    @ApiOperation(value = "零星采购", notes = "零星采购",response = IpPaymentApplyVo.class)
    public Result getRetailPurchasesList(@RequestBody IpPurchasesDto purchasesDto) throws Exception{
        List<IpPaymentApplyVo> applyVoList = invoiceService.getRetailPurchasesList(purchasesDto);
        return Result.ok(applyVoList);
    }

    @PostMapping("/getEngineeringPurchasesList")
    @ApiOperation(value = "工程采购", notes = "工程采购",response = IpPaymentApplyVo.class)
    public Result getEngineeringPurchasesList(@RequestBody IpPurchasesDto purchasesDto) throws Exception{
        IpPaymentApplyVo paymentApplyVo = invoiceService.getEngineeringPurchasesList(purchasesDto);
        return Result.ok(paymentApplyVo);
    }


    @RequestMapping(value = "/exportExcel", method = RequestMethod.POST)
    @ApiOperation("发票记录列表Excel导出")
    public void exportExcel(@RequestBody IpInvoicePageDto ipInvoicePageDto, HttpServletResponse response) throws Exception {
        invoiceService.getExcel(response, ipInvoicePageDto);

    }
}
