package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpInvoiceEntityPageDto;
import com.ekingwin.bas.cloud.entity.IpInvoiceEntity;
import com.ekingwin.bas.cloud.service.IpInvoiceEntityService;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: IpInvoiceEntityController
 * @Author: liujunfeng
 * @Date: 2019/12/9 22:28
 * @description:
 */
@RestController
@RequestMapping("/invoiceEntity/")
@Api(tags = "开票信息", description = "开票信息", value = "开票信息")
public class IpInvoiceEntityController {

    @Autowired
    IpInvoiceEntityService invoiceEntityService;


    @PostMapping("/getInvoiceLsit")
    @ApiOperation(value = "开票信息列表", notes = "开票信息列表",response = IpInvoiceEntity.class)
    public Result getInvoiceLsit(@RequestBody IpInvoiceEntityPageDto entityPageDto) throws Exception {
        PageInfo pageInfo = invoiceEntityService.getInvoiceLsit(entityPageDto);
        return Result.ok(pageInfo);
    }


}
