package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpNoticeDto;
import com.ekingwin.bas.cloud.dto.IpNoticePageDto;
import com.ekingwin.bas.cloud.service.IpNoticeService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpNoticeVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

/**
 * @program: rcworkspace
 * @description:
 * @author: huangyl
 * @create: 2019-07-11 15:24
 **/
@RestController
@RequestMapping("/notice/")
@Api(tags = "公告", description = "公告", value = "公告")
public class IpNoticeController {

    @Autowired
    @Qualifier(value = "ipNoticeServiceImpl")
    private IpNoticeService ipNoticeService;


    @PostMapping("/noticeLsit")
    @ApiOperation(value = "公告列表", notes = "公告列表",response = IpNoticeVo.class)
    public Result getNoticeLsit(@RequestBody IpNoticePageDto ipNoticePageDto) throws Exception{
        PageInfo pageInfo=ipNoticeService.getNoticeList(ipNoticePageDto);
        return Result.ok(pageInfo);
    }
    @PostMapping("/getNoticeById/{id}")
    @ApiOperation(value = "获取公告详情", notes = "获取公告详情",response = IpNoticeVo.class)
    public Result getNoticeById(@PathVariable(value = "id") Long id)throws Exception{
        IpNoticeVo ipNoticeVo=ipNoticeService.getNoticeById(id);
        return Result.ok(ipNoticeVo);
    }
    @PostMapping("/updateNotice")
    @ApiOperation(value = "修改公告", notes = "修改公告")
    public Result updateNotice(@RequestBody IpNoticeDto ipNoticeDto)throws Exception{
        boolean result =ipNoticeService.updateNotice(ipNoticeDto);
        return Result.ok(result);
    }

    @PostMapping("/addNotice")
    @ApiOperation(value = "添加公告", notes = "添加公告")
    public Result addNotice(@RequestBody IpNoticeDto ipNoticeDto)throws Exception{
        boolean result =ipNoticeService.addNotice(ipNoticeDto);
        return Result.ok(result);
    }
    @PostMapping("/delNotice/{id}")
    @ApiOperation(value = "删除公告", notes = "删除公告")
        public Result delNotice(@PathVariable(value = "id") Long id)throws Exception{
            boolean result =ipNoticeService.delNotice(id);
            return Result.ok(result);
    }
}
