package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.entity.IpcOrder;
import com.ekingwin.bas.cloud.entity.IpcOrderDraftsWithBLOBs;
import com.ekingwin.bas.cloud.rabbit.sender.OrderCancelSender;
import com.ekingwin.bas.cloud.service.IpOrderDrafterService;
import com.ekingwin.bas.cloud.service.IpOrderService;
import com.ekingwin.bas.cloud.service.IpcOrderService;
import com.ekingwin.bas.cloud.util.BackResult;
import com.ekingwin.bas.cloud.util.PublicJsonObject;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-30 18:51
 **/
@RestController
@RequestMapping(value = "/order/")
@Api(tags = "订单管理", description = "订单管理", value = "订单管理")
public class IpOrderController {

    @Autowired
    private IpOrderService ipOrderService;

    @Autowired
    private IpcOrderService ipcOrderService;

    @Autowired
    private OrderCancelSender orderCancelSender;

    @Autowired
    private IpOrderDrafterService ipOrderDrafterService;

    @PostMapping("/getOrderCarDetail")
    @ApiOperation(value = "获取去下单商品详情", notes = "获取去下单商品详情",response = IpOrderCarDetailVo.class)
    public Result getOrderCarDetail(@RequestBody IpOrderDetailDto ipOrderDetailDto) throws Exception{
        IpOrderCarDetailVo ipOrderCarDetailVo =ipOrderService.getOrderCarDetail(ipOrderDetailDto);
        return Result.ok(ipOrderCarDetailVo);
    }

    @PostMapping("/checkStockSubmit")
    @ApiOperation(value = "提交验证库存", notes = "提交验证库存")
    public Result checkStockSubmit(@RequestBody IpOrderDetailDto ipOrderDetailDto) throws Exception{
        ipOrderService.checkStockSubmit(ipOrderDetailDto);
        return Result.ok();
    }


    @PostMapping("/saveOrUpdateOrder")
    @ApiOperation(value = "保存与修改订单信息", notes = "保存与修改订单信息")
    public Result saveOrUpdateOrder(@RequestBody IpOrderAddDto ipOrderAddDto) throws Exception{
        IpOrderResultVo orderResultVo =ipOrderService.saveOrUpdateOrder(ipOrderAddDto);
        return Result.ok(orderResultVo);
    }

    @PostMapping("/getMyOrderList")
    @ApiOperation(value = "我的订单和全部订单", notes = "我的订单和全部订单")
    public BackResult getMyOrderList(@RequestBody IpOrderMyListVo ipOrderMyListVo) throws Exception{
        PageInfo orderListByUserId = ipcOrderService.getOrderListByUserId(ipOrderMyListVo);
        return PublicJsonObject.jsonObject(orderListByUserId);
    }
/*
    @PostMapping("/getMyOrderList")
    @ApiOperation(value = "订单列表")
    public Result getMyOrderList(@RequestBody IpOrderAddressDto orderAddressDto){
        PageInfo<IpCustOrderAddressVo> custAddress = ipcOrderService.getOrderListByUserId(orderAddressDto);
        return Result.ok(custAddress);
    }*/

    @PostMapping("/orderCancel")
    @ApiOperation(value = "订单取消", notes = "订单取消")
    public Result orderCancel(@RequestBody OrderCancelDto orderCancelDto) throws Exception{
        ipcOrderService.orderCancel(orderCancelDto);
        return Result.ok();
    }

//    @PostMapping("/orderCancelQuee")
//    @ApiOperation(value = "订单取消对列", notes = "订单取消对列")
//    public Result orderCancelQuee(@RequestBody OrderCancelDto orderCancelDto) throws Exception{
//        String toString = JSONObject.fromObject(orderCancelDto).toString();
//        orderCancelSender.send("payment.order.cancel",toString);
//        return Result.ok();
//    }

    @PostMapping("/getCustAddress")
    @ApiOperation(value = "获取订单地址", notes = "获取订单地址")
    public Result getCustAddress(@RequestBody IpOrderAddressDto orderAddressDto){
        PageInfo<IpCustOrderAddressVo> custAddress = ipcOrderService.getCustAddress(orderAddressDto);
        return Result.ok(custAddress);
    }
    @PostMapping("/getOrderType/{id}")
    @ApiOperation(value = "获取草稿订单类型", notes = "获取草稿订单类型")
    public Result getOrderType(@PathVariable(value = "id") int id){
        IpcOrderDraftsWithBLOBs orderDrafts = ipOrderDrafterService.getOrderDrafts(id);
        String ordertype = orderDrafts.getOrdertype();
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("ordertype",ordertype);
        return  Result.ok(jsonObject);
    }

    @PostMapping("/getOrderTypeByInstid/{instid}")
    @ApiOperation(value = "根据流程实例号获取订单类型", notes = "根据流程实例号获取订单类型")
    public Result getOrderTypeByInstid(@PathVariable(value = "instid") String instid) throws Exception{
        IpcOrder order = ipcOrderService.getOrderDetailByInstid(instid);
        String ordertype = order.getOrdertype();
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("ordertype",ordertype);
        return  Result.ok(jsonObject);
    }
}
