package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.service.IpOrderDeliverService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpOrderCarDetailVo;
import com.ekingwin.bas.cloud.vo.IpOrderDeliverVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-05 10:56
 **/
@RestController
@RequestMapping(value = "/deliver/")
@Api(tags = "送货单", description = "送货单", value = "送货单")
public class IpOrderDeliverController {

    @Autowired
    private IpOrderDeliverService ipOrderDeliverService;


    @PostMapping("/saveOrUpdateDeliver")
    @ApiOperation(value = "保存发货单信息", notes = "保存发货单信息")
    public Result saveOrUpdateDeliver(@RequestBody IpOrderDeliverDto ipOrderDeliverDto) throws Exception{
        Long id=ipOrderDeliverService.saveOrUpdateDeliver(ipOrderDeliverDto);
        return  Result.ok(id);
    }
    @PostMapping("/getOrderDeliverList")
    @ApiOperation(value = "获取发货单列表", notes = "获取发货单列表",response = IpOrderDeliverVo.class)
    public Result getOrderDeliverList(@RequestBody IpOrderDeliverListDto ipOrderDeliverListDto){
        PageInfo pageInfo  =ipOrderDeliverService.getOrderDeliverList(ipOrderDeliverListDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/saveLogistics")
    @ApiOperation(value = "保存物流信息", notes = "保存物流信息")
    public Result saveLogistics(@RequestBody IpOrderDeliverLogisticsDto ipOrderDeliverLogisticsDto) throws Exception{
        int i  =ipOrderDeliverService.saveOrUpdateLogistics(ipOrderDeliverLogisticsDto);
        return Result.ok();
    }

    @PostMapping("/getDeliverDetail")
    @ApiOperation(value = "获取发货单详情", notes = "获取发货单详情",response = IpOrderDeliverVo.class)
    public Result getDeliverDetail(@RequestBody IpOrderDeliverSearchDto ipOrderDeliverSearchDto){
        IpOrderDeliverVo ipOrderDeliverVo  =ipOrderDeliverService.getDeliverDetail(ipOrderDeliverSearchDto);
        return Result.ok(ipOrderDeliverVo);
    }

    @PostMapping("/getDeliverDetailMobile")
    @ApiOperation(value = "移动端获取发货单详情", notes = "移动端获取发货单详情",response = IpOrderDeliverVo.class)
    public Result getDeliverDetailMobile(@RequestBody IpOrderDeliverSearchDto ipOrderDeliverSearchDto){
        IpOrderDeliverVo ipOrderDeliverVo  =ipOrderDeliverService.getDeliverDetailMobile(ipOrderDeliverSearchDto);
        if(ipOrderDeliverVo==null||ipOrderDeliverVo.equals("null")){
            return Result.error(500,"您不是该送货单的收货确认方!");
        }
        return Result.ok(ipOrderDeliverVo);
    }

    @PostMapping("/getLogisticsByOrderNum")
    @ApiOperation(value = "根据订单号和商品编码获取物流信息", notes = "根据订单号和商品编码获取物流信息",response = IpOrderDeliverVo.class)
    public Result getLogisticsByOrderNum(@RequestBody IpOrderLogisticsSearchDto ipOrderLogisticsSearchDto){
        List<IpOrderDeliverVo>  ipOrderDeliverVos  =ipOrderDeliverService.getOrderDeliverByOrderNum(ipOrderLogisticsSearchDto);
        return Result.ok(ipOrderDeliverVos);
    }

}
