package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpOrderReconciliationRecordPageDto;
import com.ekingwin.bas.cloud.service.IpOrderReconciliationRecordService;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * @ClassName: IpOrderReconciliationRecordController
 * @Author: liujunfeng
 * @Date: 2019/11/28 15:12
 * @description:
 */
@RestController
@RequestMapping("/orderReconciliation/")
@Api(tags = "订单对账", description = "订单对账", value = "订单对账")
public class IpOrderReconciliationRecordController {

    @Autowired
    IpOrderReconciliationRecordService recordService;

    @PostMapping(value = "getReconciliationRecordList")
    @ApiOperation(value = "订单对账列表", notes = "订单对账列表")
    public Result getReconciliationRecordList(@RequestBody IpOrderReconciliationRecordPageDto recordPageDto) throws Exception{
        PageInfo pageInfo = recordService.getReconciliationRecordList(recordPageDto);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "updateReconciliationOrderStatus")
    @ApiOperation(value = "确认订单对账", notes = "确认订单对账")
    public Result updateReconciliationOrderStatus(@RequestBody IpOrderReconciliationRecordPageDto recordDto) throws Exception{
        recordService.updateReconciliationOrderStatus(recordDto);
        return Result.ok();
    }

    @RequestMapping(value = "/getExcel",method = RequestMethod.POST)
    @ApiOperation(value = "对账表格导出")
    public void getExcel(@RequestBody IpOrderReconciliationRecordPageDto ipOrderReconciliationRecordPageDto, HttpServletResponse response)throws Exception{
        recordService.getExcel(ipOrderReconciliationRecordPageDto,response);
    }

}
