package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpOrderRejectGoodsConfirmDto;
import com.ekingwin.bas.cloud.dto.IpOrderRejectSearchDto;
import com.ekingwin.bas.cloud.dto.IpOrderRejectedGoodsDto;
import com.ekingwin.bas.cloud.service.IpOrderRejectedService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpOrderRejectedVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 退货管理
 * @author: zhangjie
 * @create: 2019-10-16 14:37
 **/
@RestController
@RequestMapping(value = "/orderRejected/")
@Api(tags = "退货管理", description = "退货管理", value = "退货管理")
public class IpOrderRejectedController {

    @Autowired
    private IpOrderRejectedService ipOrderRejectedService;


    @PostMapping(value = "saveRejectedGoods")
    @ApiOperation(value = "保存退货单信息", notes = "保存退货单信息")
    public Result saveRejectedGoods(@RequestBody IpOrderRejectedGoodsDto goodsDto) throws Exception{
        Long rejectId=ipOrderRejectedService.saveReject(goodsDto);
        return  Result.ok(rejectId);
    }

    @PostMapping(value = "getOrderRejectedList")
    @ApiOperation(value = "获取退货单列表", notes = "获取退货单列表")
    public Result getOrderRejectedList(@RequestBody IpOrderRejectSearchDto goodsDto) throws Exception{
        PageInfo<IpOrderRejectedVo>  pageInfo=ipOrderRejectedService.getOrderRejectedList(goodsDto);
        return  Result.ok(pageInfo);
    }


    @PostMapping(value = "updateRejectGoodsConfim")
    @ApiOperation(value = "退货确认", notes = "退货确认")
    public Result updateRejectGoodsConfim(@RequestBody IpOrderRejectGoodsConfirmDto goodsConfirmDto) throws Exception{
       ipOrderRejectedService.updateRejectGoodsConfim(goodsConfirmDto);
        return  Result.ok();
    }

    @GetMapping(value = "getOrderRejectedDetail/{id}")
    @ApiOperation(value = "获取退货单详情", notes = "获取退货单详情")
    public Result getOrderRejectedDetail(@PathVariable(value = "id") String id) throws Exception{
        IpOrderRejectedVo orderRejectedDetail = ipOrderRejectedService.getOrderRejectedDetail(id);
        return  Result.ok(orderRejectedDetail);
    }
}
