package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpOrderReportDto;
import com.ekingwin.bas.cloud.dto.IpOrderSupplierHomeDto;
import com.ekingwin.bas.cloud.service.IpOrderReportService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpOrderReportVo;
import com.ekingwin.bas.cloud.vo.IpOrderSupplierHomeDayVo;
import com.ekingwin.bas.cloud.vo.IpOrderSupplierHomeVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-23 11:29
 **/
@RestController
@RequestMapping("/orderReport/")
@Api(tags = "业务报表", description = "业务报表", value = "业务报表")
public class IpOrderReportController {


    @Autowired
    private IpOrderReportService ipOrderReportService;

    @PostMapping("/getOrderReport")
    @ApiOperation(value = "获取订单汇总", notes = "获取订单汇总",response = IpOrderReportVo.class)
    public Result getOrderReport(@RequestBody IpOrderReportDto ipOrderReportDto){
        PageInfo pageInfo=ipOrderReportService.getOrderReport(ipOrderReportDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/getSupplierHome")
    @ApiOperation(value = "获取供应商首页汇总", notes = "获取供应商首页汇总",response = IpOrderSupplierHomeVo.class)
    public Result getSupplierHome(@RequestBody IpOrderSupplierHomeDto ipOrderReportDto){
        IpOrderSupplierHomeVo ipOrderSupplierHomeVo=ipOrderReportService.getSupplierHome(ipOrderReportDto);
        return Result.ok(ipOrderSupplierHomeVo);
    }

    @PostMapping("/getSupplierDay")
    @ApiOperation(value = "获取供应商首页七日汇总", notes = "获取供应商首页七日汇总",response = IpOrderSupplierHomeDayVo.class)
    public Result getSupplierDay(@RequestBody IpOrderSupplierHomeDto ipOrderReportDto){
        List<IpOrderSupplierHomeDayVo> ipOrderSupplierHomeVo=ipOrderReportService.getSupplierDay(ipOrderReportDto.getSupplierid());
        return Result.ok(ipOrderSupplierHomeVo);
    }
   @ApiOperation(value = "导出Excel",notes = "导出Excel")
    @PostMapping(value = "/exportExcel")
    public void exportExcel( @RequestBody IpOrderReportDto ipOrderReportDto, HttpServletResponse response)throws Exception{
        ipOrderReportService.getExcel(ipOrderReportDto,response);
   }
}


