package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpOrderReceiverDto;
import com.ekingwin.bas.cloud.dto.IpOrderReceiverSearchDto;
import com.ekingwin.bas.cloud.service.IpOrderReceiverService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpOrderReceiverVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-07 15:35
 **/
@RestController
@RequestMapping(value = "/receiver/")
@Api(tags = "收货", description = "收货", value = "收货")
public class IpOrdetReceiverController {


    @Autowired
    private IpOrderReceiverService ipOrderReceiverService;


    @PostMapping("/saveReceiver")
    @ApiOperation(value = "保存收货单信息", notes = "保存收货单信息")
    public Result saveReceiver(@RequestBody IpOrderReceiverDto ipOrderReceiverDto) throws Exception{
        String instid=ipOrderReceiverService.saveReceiver(ipOrderReceiverDto);
        return  Result.ok(instid);
    }
    @PostMapping("/getReceiverData")
    @ApiOperation(value = "获取收货单信息", notes = "获取收货单信息",response = IpOrderReceiverVo.class)
    public Result getReceiverData(@RequestBody IpOrderReceiverSearchDto ipOrderReceiverSearchDto){
        IpOrderReceiverVo ipOrderReceiverVo=ipOrderReceiverService.getOrderReceiverData(ipOrderReceiverSearchDto);
        return  Result.ok(ipOrderReceiverVo);
    }


    @PostMapping("/initReceiverInvoice")
    @ApiOperation(value = "保存收货单信息", notes = "保存收货单信息")
    public Result initReceiverInvoice(@RequestBody IpOrderReceiverDto ipOrderReceiverDto) throws Exception{
        ipOrderReceiverService.initReceiverInvoice(ipOrderReceiverDto,null);
        return  Result.ok();
    }
   @PostMapping("/initPass")
    @ApiOperation(value = "收货单成功信息", notes = "收货单成功信息")
    public Result initPass(@RequestBody IpOrderReceiverDto ipOrderReceiverDto) throws Exception{
        ipOrderReceiverService.initPass(ipOrderReceiverDto.getInstid());
        return  Result.ok();
    }

    @PostMapping("/initFail")
    @ApiOperation(value = "收货单审批不通过", notes = "收货单审批不通过")
    public Result initFail(@RequestBody IpOrderReceiverDto ipOrderReceiverDto) throws Exception{
        ipOrderReceiverService.initFail(ipOrderReceiverDto.getInstid());
        return  Result.ok();
    }
}
