package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpPaymentDto;
import com.ekingwin.bas.cloud.dto.IpPaymentPageDto;
import com.ekingwin.bas.cloud.dto.IpPaymentPayInfoDto;
import com.ekingwin.bas.cloud.dto.IpPurchasesDto;
import com.ekingwin.bas.cloud.service.IpPaymentService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpPaymentApplyVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@RestController
@RequestMapping("/payment")
@Api(tags = "付款单",description = "付款单", value = "付款单")
public class IpPaymentController {

    @Autowired
    private IpPaymentService ipPaymentService;

    @RequestMapping(value = "/paymentInfo",method = RequestMethod.POST)
    @ApiOperation("付款单列表信息")
    public Result getPaymentInfo(@RequestBody IpPaymentPageDto ipPaymentPageDto)throws Exception{
        return  Result.ok(ipPaymentService.getPaymentInfo(ipPaymentPageDto));
    }

    @RequestMapping(value = "/saveOrUpdatePaymen",method = RequestMethod.POST)
    @ApiOperation("新增和保存信息")
    public Result saveOrUpdatePaymen(@RequestBody IpPaymentDto ipPaymentDto)throws Exception{
       String ipPaymentDto1 = ipPaymentService.saveOrUpdatePaymen(ipPaymentDto);
        return Result.ok(ipPaymentDto1);
    }

    @RequestMapping(value = "/queryPayment" ,method = RequestMethod.POST)
    @ApiOperation("付款单明细")
    public Result queryPayment(@RequestBody IpPaymentPageDto ipPaymentPageDto)throws Exception{
        return Result.ok(ipPaymentService.queryPayment(ipPaymentPageDto));
    }

    @RequestMapping(value = "/exportExcel",method = RequestMethod.POST)
    @ApiOperation("付款单列表Excel导出")
    public void exportExcel(HttpServletResponse response,@RequestBody IpPaymentPageDto ipPaymentPageDto)throws Exception{
        ipPaymentService.getExcel(ipPaymentPageDto,response);
    }

    @PostMapping("/sapDetailList")
    @ApiOperation(value = "查看SAP明细", notes = "查看SAP明细")
    public Result sapDetailList(@RequestBody IpPaymentPayInfoDto payInfoDto) throws Exception{
        PageInfo pageInfo = ipPaymentService.sapDetailList(payInfoDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/getContractChoice")
    @ApiOperation(value = "合同选择", notes = "合同选择")
    public Result getContractChoice(@RequestBody IpPaymentPayInfoDto payInfoDto) throws Exception{
        PageInfo pageInfo = ipPaymentService.getContractChoice(payInfoDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/getReconciliationChoice")
    @ApiOperation(value = "对账单选择", notes = "对账单选择")
    public Result getReconciliationChoice(@RequestBody IpPaymentPayInfoDto payInfoDto) throws Exception{
        List<String> contractVos = ipPaymentService.getReconciliationChoice(payInfoDto);
        return Result.ok(contractVos);
    }


    @PostMapping("/getRetailPurchasesList")
    @ApiOperation(value = "零星采购", notes = "零星采购")
    public Result getRetailPurchasesList(@RequestBody IpPurchasesDto purchasesDto) throws Exception{
        List<IpPaymentApplyVo> applyVoList = ipPaymentService.getRetailPurchasesList(purchasesDto);
        return Result.ok(applyVoList);
    }

    @PostMapping("/getEngineeringPurchasesList")
    @ApiOperation(value = "工程采购", notes = "工程采购")
    public Result getEngineeringPurchasesList(@RequestBody IpPurchasesDto purchasesDto) throws Exception{
        IpPaymentApplyVo paymentApplyVo = ipPaymentService.getEngineeringPurchasesList(purchasesDto);
        return Result.ok(paymentApplyVo);
    }



}
