package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpProjectSearchDto;
import com.ekingwin.bas.cloud.dto.IpProjectUserDto;
import com.ekingwin.bas.cloud.service.IpProjectService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpProjectStagesUserVo;
import com.ekingwin.bas.cloud.vo.IpProjectStagesVo;
import com.ekingwin.bas.cloud.vo.IpProjectUserVo;
import com.ekingwin.bas.cloud.vo.IpProjectVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-29 17:38
 **/
@RestController
@RequestMapping(value = "/project/")
@Api(tags = "项目管理", description = "项目管理", value = "项目管理")
public class IpProjectController {

    @Autowired
    private IpProjectService  ipProjectService;


    @PostMapping("/getAllproject")
    @ApiOperation(value = "获取项目列表", notes = "获取项目列表",response = IpProjectVo.class)
    public Result getAllproject(@RequestBody IpProjectSearchDto ipProjectSearchDto){
        PageInfo pageInfo=ipProjectService.getProject(ipProjectSearchDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/getStages")
    @ApiOperation(value = "获取项目列表", notes = "获取项目列表",response = IpProjectStagesVo.class)
    public  Result getStages(@RequestBody IpProjectSearchDto ipProjectSearchDto){
        List<IpProjectStagesVo>  ipProjectStagesVos=ipProjectService.getStages(ipProjectSearchDto);
        return Result.ok(ipProjectStagesVos);
    }

    @PostMapping("/getStagesUser")
    @ApiOperation(value = "获取项目收货联系人", notes = "获取项目收货联系人",response = IpProjectStagesUserVo.class)
    public  Result getStagesUser(@RequestBody IpProjectSearchDto ipProjectSearchDto){
        List<IpProjectStagesUserVo>  ipProjectStagesVos=ipProjectService.getStagesUser(ipProjectSearchDto);
        return Result.ok(ipProjectStagesVos);
    }

    @PostMapping("/getProjetReceiverUser")
    @ApiOperation(value = "获取项目的收货人员信息",notes="获取项目的收货人员信息",response = IpProjectUserVo.class)
    public Result getProjetReceiverUser(@RequestBody IpProjectUserDto ipProjectUserDto) throws Exception{
        PageInfo<IpProjectUserVo> ipProjectUserVoPageInfo = ipProjectService.getProjectReceiverUser(ipProjectUserDto);
        return Result.ok(ipProjectUserVoPageInfo);
    }



    @PostMapping("/insertOrUpdateReceiverInfo")
    @ApiOperation(value = "新增或者修改收货方人员信息",notes = "新增或者修改收货方人员信息")
    public Result insertOrUpdateReceiverInfo(@RequestBody IpProjectUserDto ipProjectUserDto) throws Exception{
        int result = ipProjectService.insertOrUpdateReceiverUser(ipProjectUserDto);
        if(result>0){
            return Result.ok();
        }else{
            return Result.error(500,"您选择的分期已配置了收货地址，请重新选择");
        }
    }

    @PostMapping("deleteReceiverUser")
    @ApiOperation(value = "删除收货方信息",notes ="删除收货方信息")
    public Result deleteReceiverUser(@RequestBody IpProjectUserDto ipProjectUserDto) throws Exception{
        int result = ipProjectService.deleteReceiverUser(ipProjectUserDto);
        if(result>0){
            return Result.ok();
        }else{
            return Result.error();
        }
    }
}
