package com.ekingwin.bas.cloud.web;


import com.ekingwin.bas.cloud.dto.ProIpOrdersDto;
import com.ekingwin.bas.cloud.infra.web.BaseController;
import com.ekingwin.bas.cloud.service.ProIpOrdersService;
import com.ekingwin.bas.cloud.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;


@RestController
@RequestMapping("/proiporder")
@Api(tags = "带下单流程相关接口", description = "带下单流程数据保存", value = "带下单流程数据保存")
public class ProIpOrdersController extends BaseController{
	@Autowired
	@Qualifier(value="proIpOrdersServiceImpl")
	private ProIpOrdersService proIpOrdersService;

	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(value = "保存", notes = "保存",response = ProIpOrdersDto.class)
	public Result save(@RequestBody ProIpOrdersDto proIpOrdersDto) throws Exception {
		String id =proIpOrdersService.save(proIpOrdersDto);
		HashMap<Object, Object> obj = new HashMap<Object, Object>();
		obj.put("id",id);
		return Result.ok(obj);
	}
	@RequestMapping(value = "/selectById/{instanceid}", method = RequestMethod.POST)
	@ApiOperation(value = "根据id获取流程信息", notes = "根据id获取流程信息",response = ProIpOrdersDto.class)
	public Result save(@PathVariable(value = "instanceid") String instanceid) throws Exception {
		ProIpOrdersDto proIpOrdersDto =proIpOrdersService.selectByInstanceId(instanceid);
		return Result.ok(proIpOrdersDto);
	}
}
