package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpProjectContractDetailDto;
import com.ekingwin.bas.cloud.dto.IpProjectContractManagerDto;
import com.ekingwin.bas.cloud.service.IpProjectContractManagerService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpProjectContractSearchDetailVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program:
 * @description:
 * @author: yuzm
 * @create: 2019-10-14 10:17
 **/
@RestController
@RequestMapping(value = "/projectContract/")
@Api(tags = "采购合同管理", description = "采购合同管理", value = "采购合同管理")
public class ProjectContractManagerController {

    @Autowired
    private IpProjectContractManagerService ipProjectContractManagerService;


    @ApiOperation(value = "查询合同列表", notes = "查询合同列表")
    @PostMapping(value = "/selectProjectContractList")
    public Result selectGroupBuyingList(@RequestBody IpProjectContractManagerDto ipProjectContractManagerDto) throws Exception{
        PageInfo pageInfo = ipProjectContractManagerService.selectProjectContractList(ipProjectContractManagerDto);
        return Result.ok(pageInfo);
    }

    @ApiOperation(value = "查询合同详情", notes = "查询合同详情",response = IpProjectContractSearchDetailVo.class)
    @PostMapping(value = "/selectProjectContractDetail")
    public Result selectGroupBuyingDetail(@RequestBody IpProjectContractDetailDto ipProjectContractDetailDto ) throws Exception{
        IpProjectContractSearchDetailVo ipProjectContractSearchDetailVo = ipProjectContractManagerService.selectProjectContractDetail(ipProjectContractDetailDto);
        return Result.ok(ipProjectContractSearchDetailVo);
    }



}
