package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.QrCodeDto;
import com.ekingwin.bas.cloud.util.QrCodeUtils;
import com.ekingwin.bas.cloud.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-06 16:31
 **/
@RestController
@RequestMapping("/qrCode/")
@Api(tags = "生成二维码", description = "生成二维码", value = "生成二维码")
public class QrcodeController {

    @Value("${receiver.goodsurl}")
    private String receiverUrl;

    @PostMapping("/qrcodeCreate")
    @ApiOperation(value = "生成s收货二维码", notes = "生成二维码")
    public Result qrcodeCreate(@RequestBody QrCodeDto qrCodeDto){
        String content = qrCodeDto.getContent();
        JSONObject jsonObject=JSONObject.fromObject(content);
       String url=jsonObject.get("url").toString();
        String[] split = url.split("\\?");
        String receiverGoodsUrl=receiverUrl+"?"+split[1];
        jsonObject.put("url",receiverGoodsUrl);
        String qrContent = jsonObject.toString();
        String code= QrCodeUtils.creatRrCode(qrContent,qrCodeDto.getWidth(),
                qrCodeDto.getHeight(),qrCodeDto.getType());
        return Result.ok(code);
    }
}
