package com.ekingwin.bas.cloud.service;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.client.RestTemplate;

@EnableAutoConfiguration
@SpringBootApplication
@MapperScan(basePackages = "com.ekingwin.bas.cloud")
@ComponentScan(basePackages={"com.ekingwin.bas"})
@EnableCaching
public class OrgServiceApplication  extends SpringBootServletInitializer implements WebApplicationInitializer {

	@Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(OrgServiceApplication.class);
    }
	
	@Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }
	
	public static void main(String[] args) {
		SpringApplication.run(OrgServiceApplication.class, args);
//		try (ConfigurableApplicationContext context = 
//		          SpringApplication.run(BasServiceApplication.class, args)) {
//		       System.out.println("context: " + context);
//		      }
		
	}

}
