package com.ekingwin.bas.cloud.util;

import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class Client {

	private Logger logger = LoggerFactory.getLogger(Client.class);

	public JSONObject getToken(String url, String json){
		return postCall(url, json);
	}
	
	public JSONObject getUserInfo(String url){
		return getCall(url);
	}
	public JSONObject getCode(String url){
		return getCall(url);
	}

	private JSONObject getCall(String url){
		logger.info("request url is :"+url);
		OkClient okClient = new OkClient(url);
		Response response = okClient.getCall();
		JSONObject responseJson = null ;
		try {
			responseJson = new JSONObject(response.body().string());
		} catch (JSONException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return  responseJson ;
	}
	
	private JSONObject postCall(String url, String json){
		OkClient okClient = new OkClient(url);
		Response response = okClient.postCall(json);
		JSONObject responseJson = null;
		try {
			responseJson = new JSONObject(response.body().string());
		} catch (JSONException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return  responseJson ;
	}
}
