package com.ekingwin.bas.cloud.util;

import okhttp3.*;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;

public class OkClient {
	private static final MediaType    JSON = MediaType.parse("application/json");
	private              OkHttpClient client;
	private              String       url;
	public final static  int          CONNECT_TIMEOUT = 10 * 60;
	public final static  int          READ_TIMEOUT = 15 * 60;
	public final static  int          WRITE_TIMEOUT = 15 * 60;

	public OkClient(String url) {
		this.url = url;
		this.client = new OkHttpClient();
	}
	
	private static SSLSocketFactory createSSLSocketFactory() {
	    SSLSocketFactory sSLSocketFactory = null;
	    try {
	        SSLContext sc = SSLContext.getInstance("TLS");
	        sc.init(null, new TrustManager[]{new TrustAllManager()},
	                new SecureRandom());
	        sSLSocketFactory = sc.getSocketFactory();
	    } catch (Exception e) {
	    }
	    return sSLSocketFactory;
	}

	public Response getCall() {
		Request request = new Request.Builder().url(url).build();
		Response response = null;
		client=client.newBuilder().readTimeout(READ_TIMEOUT, TimeUnit.SECONDS).writeTimeout(WRITE_TIMEOUT, TimeUnit.SECONDS)
				.connectTimeout(CONNECT_TIMEOUT, TimeUnit.SECONDS).sslSocketFactory(createSSLSocketFactory()).hostnameVerifier(new TrustAllHostnameVerifier()).build();
		try {
			response = client.newCall(request).execute();
		} catch (IOException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
		return response;
	}

	public Response postCall(String json) {
		RequestBody body = RequestBody.create(JSON, json);
		Request request = new Request.Builder().url(url).post(body).build();
		Response response = null;
		client=client.newBuilder().sslSocketFactory(createSSLSocketFactory()).hostnameVerifier(new TrustAllHostnameVerifier()).build();
		try {
			response = client.newCall(request).execute();
		} catch (IOException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
		return response;
	}
	

}
