package com.ekingwin.bas.cloud.util;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import net.sf.json.JSONObject;

import java.util.HashMap;
import java.util.Random;

public class SmsUtils {


    //发送单条短信
    public static Result SendSms(String phoneNumber, String TemplateCode, String signName,String accessKeyId,
                                 String secret, String domainUrl){

        DefaultProfile profile = DefaultProfile.getProfile("default", accessKeyId, secret);
        IAcsClient client = new DefaultAcsClient(profile);
        HashMap map = new HashMap();
        String code = getSixCode();
        map.put("code",code);
        JSONObject jsonObject = JSONObject.fromObject(map.toString());
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(domainUrl);
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", phoneNumber);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", TemplateCode);
        request.putQueryParameter("TemplateParam",jsonObject.toString());
        try {
            CommonResponse response = client.getCommonResponse(request);
            JSONObject jsonObject1 = JSONObject.fromObject(response.getData());
            if(jsonObject1.get("Code").equals("OK")){
                Result result = new Result();
                result.put("phoneNumber",phoneNumber);
                result.put("verificationCode",code);
                result.put("content",SmsTemplate.RESPONSE_CODE.get("PASSWORDRESETTEMPLATE").replace("${code}",code));
                return Result.ok(result);
            }else {
               return Result.error(500,jsonObject1.get("Message").toString());
            }
        } catch (ServerException e) {
            e.printStackTrace();
            return Result.error(500,"短信接口请求异常");
        } catch (ClientException e) {
            e.printStackTrace();
            return Result.error(500,"短信接口请求异常");
        }
    }

    public static String getSixCode() {
        Random ran = new Random();
        int six = 100000 + ran.nextInt(900000);
        return String.valueOf(six);
    }
}

