package com.ekingwin.bas.cloud.verificationCode.service;

import java.util.List;

import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.service.IBaseCurdService;
import com.ekingwin.bas.cloud.verificationCode.dto.VerificationCodeDto;

public interface IVerificationCodeService extends IBaseCurdService<VerificationCodeDto> {
	/**
	 * 通过手机号、或者邮箱获取验证码信息
	 * @param way
	 * @return
	 * @throws BasException
	 */
	public List<VerificationCodeDto> getByWayAndAction(String way,String use) throws BasException;
	
	/**
	 * 发送验证码
	 * @param verificationCodeDto
	 * @return
	 * @throws BasException
	 */
	public void send(VerificationCodeDto verificationCodeDto) throws BasException;
}
