package com.ekingwin.bas.cloud.verificationCode.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import com.ekingwin.bas.cloud.mail.dto.MailInfoDto;
import com.ekingwin.bas.cloud.mail.service.IMailService;
import com.ekingwin.bas.cloud.user.dao.UserDao;
import com.ekingwin.bas.cloud.user.dao.entity.User;
import com.ekingwin.bas.cloud.verificationCode.dao.VerificationCodeDao;
import com.ekingwin.bas.cloud.verificationCode.dao.entity.VerificationCode;
import com.ekingwin.bas.cloud.verificationCode.dto.VerificationCodeDto;
import com.ekingwin.bas.cloud.verificationCode.service.IVerificationCodeService;

@Primary
@Service
public class VerificationCodeServiceImpl extends BaseService implements IVerificationCodeService {
	@Autowired
	private VerificationCodeDao dao;
	
	@Autowired
	@Qualifier(value = "mailServiceImpl")
	private IMailService mailService;
	
	@Autowired
	private UserDao userDao;

	@Override
	public BaseResult<VerificationCodeDto> save(VerificationCodeDto object) throws BasException {
		save(object, VerificationCode.class, dao);
		return null;
	}

	@Override
	public BaseResult<VerificationCodeDto> delete(String id) throws BasException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BaseResult<PageCriteria<VerificationCodeDto>> query(QueryDTO query) throws BasException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BaseResult<VerificationCodeDto> get(String id) throws BasException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<VerificationCodeDto> getByWayAndAction(String way,String use) throws BasException {
		List<VerificationCodeDto> result = new  ArrayList<VerificationCodeDto>();
		List<VerificationCode> verificationCodeList = dao.getByWayAndAction(way,use);
		for(int i = 0 ; i < verificationCodeList.size() ; i++ ){
			VerificationCodeDto verificationCodeDto = new VerificationCodeDto();
			try {
				super.commonBuild(verificationCodeDto, verificationCodeList.get(i));
				result.add(verificationCodeDto);
			} catch (Exception e) {
				log.error(e.getMessage());
			}
			
		}
		return result;
	}

	@Override
	public void send(VerificationCodeDto verificationCodeDto) throws BasException {
		try {
			String way = verificationCodeDto.getWay();
			String  waytype = verificationCodeDto.getWaytype();
			if(way==null){
				throw new BasException("您需要填写邮箱或者手机信息！");
			}
			List<User>  userList  = userDao.getEmployeeByMobilephoneEmpuidEmail(way);
			if(userList.size()==0){
				throw new BasException("邮箱不存在，请重新核实！");
			}
			String empuid = userList.get(0).getEmpuid();
			
			verificationCodeDto.setEmpuid(empuid);
			Random rand = new Random();
			//验证码
			String code ="";
			//校验码
			String checkcode ="";
			for(int i = 0 ; i < 6 ; i++ ){
				code+=rand.nextInt(10);
				checkcode+=rand.nextInt(10);
			}
			
			verificationCodeDto.setCheckcode(checkcode);
			verificationCodeDto.setVerificationcode(code);
			// 邮箱方式
			if(waytype==null||"02".equals(waytype)){
				
				
				Map<String, Object> params =  new  HashMap<String, Object>();
				params.put("code", code);
				
				List<String> receivers = new ArrayList<String>();
				List<String> list = new ArrayList<String>();
				receivers.add(way);
				
				MailInfoDto mail = new MailInfoDto();
				mail.setParams(params);
				mail.setTemplate("verificationCodeTemplate.ftl");
				mail.setReceivers(receivers);
				mail.setSubject("九彩云账号重置密码验证");
				mail.setBcc(list);
				mail.setCc(list);
				mailService.sendMailWithTemplate(mail );
				save(verificationCodeDto);
				verificationCodeDto.setCheckcode(checkcode);
				verificationCodeDto.setVerificationcode("");
				verificationCodeDto.setEmpuid("");
			}else{
				// 短信方式
				
			}
		} catch (Exception e) {
			throw new BasException(e.getMessage());
		}
	}
	
	
}
