package com.ekingwin.bas.cloud.verificationCode.web;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;
import com.ekingwin.bas.cloud.verificationCode.dto.VerificationCodeDto;
import com.ekingwin.bas.cloud.verificationCode.service.IVerificationCodeService;

import io.swagger.annotations.Api;

@RestController
@RequestMapping("/public/verification/code")
@Api("发送验证码")
public class VerificationCodeController {
	
	@Autowired
	@Qualifier(value = "verificationCodeServiceImpl")
	private IVerificationCodeService verificationCodeService;
	
	
	@RequestMapping(value = "/send", method = RequestMethod.POST)
	public BaseResult<VerificationCodeDto> send(@RequestBody VerificationCodeDto verificationCodeDto) throws Exception {
		BaseResult<VerificationCodeDto> baseResult = new BaseResult<VerificationCodeDto>();
		baseResult.setTimestamp(String.valueOf(new Date().getTime()));
		baseResult.setPath(WebUtils.getRequest().getRequestURI());
		try {
			verificationCodeService.send(verificationCodeDto);
			baseResult.setStatus("200");
			baseResult.setData(verificationCodeDto);
		} catch (Exception e) {
			baseResult.setStatus("500");
			baseResult.setMessage(e.getMessage());
		}
		return baseResult;
	}

}
