package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.GoodsDetailDto;
import com.ekingwin.bas.cloud.dto.GoodsMessageCategoryDto;
import com.ekingwin.bas.cloud.dto.InsertMap;
import com.ekingwin.bas.cloud.dto.IpGoodsStockDto;
import com.ekingwin.bas.cloud.entity.IpGoodsEntity;
import com.ekingwin.bas.cloud.vo.GoodsMessageCategoryVo;
import com.ekingwin.bas.cloud.vo.GoodsMessageStatusVo;
import com.ekingwin.bas.cloud.vo.IpProcessGoodsVo;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:主表信息修改
 * @author: zhangjie
 * @create: 2019-06-27 16:07
 **/
@Repository
public interface IpGoodsMapper {

    /**
     * 新增商品
     * @param insertMap
     * @return
     */
    int insertGoods(InsertMap insertMap);

    /**
     * 修改商品信息
     * @param insertMap
     * @return
     */
    int updateGoods(InsertMap insertMap);

    /**
     * 获取详情
     * @param goodsId
     * @return
     */
    Map<String,Object> getGoodsDetail(Long goodsId);


    /**
     * 获取商品编码
     * @return
     */
    String getGoodNum();

    /**
     * 修改商品状态
     * @param ipGoodsEntity
     * @return
     */
    int updateGoodsStatus(IpGoodsEntity ipGoodsEntity);


    /**
     * 获取分类下所有的商品
     * @param categoryId
     * @return
     */
    List<String>  getGoodsId(String categoryId);

    /**
     * 修改商品三级分类信息
     * @param map
     * @return
     */
    int updateGoodsCategory(Map<String,String> map);

    /**
     * 修改商品一二级分类对应的分类名称
     */
    int updateFirSecCatrgoryName(Map<String,String> map);


    /**
     * 根据商品编号获取商品详情
     * @param goodsnum
     * @return
     */
    Map<String, Object> getGoodsDetailByNum(String goodsnum);

    /**
     * 判断商品是否在流程中
     * @param goodsDetailDto
     * @return
     */
    List<IpProcessGoodsVo> getGoodsNameByGoodsId(GoodsDetailDto goodsDetailDto);

    /**
     * 根据分类DI获取上架的商品数量
     * @param categoryId
     * @return
     */
    int getGoodsIdCount(String categoryId);

    /**
     * 获取三级分类
     * @param goodsId
     * @return
     */
    String getGoodsThreeCategory(String goodsId);


    /**
    * 获取商品的状态
    * @Param:  * @param messageCategoryDto
    * @return: java.util.List<com.ekingwin.bas.cloud.vo.GoodsMessageStatusVo>
    * @Author: zhangjie
    * @Date: 2019/10/21 21:39
    */
    List<GoodsMessageStatusVo> getGoodsStatus(GoodsMessageCategoryDto messageCategoryDto);



    /**
     * 获取一级分类
     * @Param:  * @param messageCategoryDto
     * @return: java.util.List<com.ekingwin.bas.cloud.vo.GoodsMessageCategoryVo>
     * @Author: zhangjie
     * @Date: 2019/10/21 22:20
     */
    List<GoodsMessageCategoryVo> getFirstCategory(GoodsMessageCategoryDto messageCategoryDto);

    /**
     * 获取二级分类
     * @Param:  * @param messageCategoryDto
     * @return: java.util.List<com.ekingwin.bas.cloud.vo.GoodsMessageCategoryVo>
     * @Author: zhangjie
     * @Date: 2019/10/21 22:20
     */
    List<GoodsMessageCategoryVo> getSecondCategory(GoodsMessageCategoryDto messageCategoryDto);

    /**
     * 获取三级分类
     * @Param:  * @param messageCategoryDto
     * @return: java.util.List<com.ekingwin.bas.cloud.vo.GoodsMessageCategoryVo>
     * @Author: zhangjie
     * @Date: 2019/10/21 22:20
     */
    List<GoodsMessageCategoryVo> getThreadCategory(GoodsMessageCategoryDto messageCategoryDto);

    /**
     * 获取商品信息
     * @Param:  * @param messageCategoryDto
     * @return: java.util.List<com.ekingwin.bas.cloud.vo.GoodsMessageCategoryVo>
     * @Author: zhangjie
     * @Date: 2019/10/21 22:20
     */
    List<Map<String,Object>> getAllGoodList(GoodsMessageCategoryDto messageCategoryDto);


    /**
    * 库存
    * @Param:  * @param stockDto
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/11/2 15:55
    */
    int updateGoodsStock(IpGoodsStockDto stockDto);
}
