package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpGoodsFreightDto;
import com.ekingwin.bas.cloud.entity.IpGoodsSuppliers;
import com.ekingwin.bas.cloud.vo.GoodsSupplierInfoVo;
import com.ekingwin.bas.cloud.vo.IpGoodsSupplierFreightVo;
import com.ekingwin.bas.cloud.vo.IpGoodsSuppliersVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:商品供应商
 * @author: zhangjie
 * @create: 2019-06-27 15:28
 **/
@Repository
public interface IpGoodsSuppliersMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpGoodsSuppliers record);

    int insertSelective(IpGoodsSuppliers record);

    IpGoodsSuppliers selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpGoodsSuppliers record);

    int updateByPrimaryKey(IpGoodsSuppliers record);

    /**
     * 删除供应商
     * @param goodsId
     * @return
     */
    int deleteByGoodsId(Long goodsId);

    /**
     * 获取供应商
     * @param goodsId
     * @return
     */
    List<IpGoodsSuppliersVo> selectByGoodsId(Long goodsId);


    /**
     * 根据区ID获取运费
     * @param ipGoodsFreightDto
     * @return
     */
    IpGoodsSupplierFreightVo getFreightPriceByAreaId(IpGoodsFreightDto ipGoodsFreightDto);

    /**
     * 根据城市ID获取运费
     * @param ipGoodsFreightDto
     * @return
     */
    IpGoodsSupplierFreightVo getFreightPriceByCityId(IpGoodsFreightDto ipGoodsFreightDto);


    /**
     * 根据省份IID获取运费
     * @param ipGoodsFreightDto
     * @return
     */
    IpGoodsSupplierFreightVo getFreightPriceByProvinceId(IpGoodsFreightDto ipGoodsFreightDto);


    /**
     * 根商品iD和供应商ID删除信息
     * @param record
     * @return
     */
    int deleteByGoodsIdAndSuppliers(IpGoodsSuppliers record);


    /**
     * 查询供应商的联系方式
     * @param supplierid
     * @return
     */
    GoodsSupplierInfoVo getGoodsSuppliersById(String supplierid);
}