package com.ekingwin.bas.cloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-27 15:28
 **/
@ApiModel("商品新增")
@Data
public class GoodsAddDto extends BasDto {

    @ApiModelProperty(value = "商品主键", required = false)
    private Long goodsId;

    /**
     * 商品信息
     */
    @ApiModelProperty(value = "商品信息", required = false)
    private Map<String, Object> goodsMap;

    /**
     * 供应商运费
     */
    @ApiModelProperty(value = "供应商信息", required = false)
    private List<IpGoodsSuppliersDto> supplierList;

    /**
     * 商品价格表
     */
    @ApiModelProperty(value = "商品价格", required = false)
    private List<IpGoodsPriceDto> priceDtoList;

    @ApiModelProperty(value = "图片", required = false)
    private String urlid;

    @ApiModelProperty(value = "商品描述", required = false)
    private String details;

    @ApiModelProperty(value = "规格参数", required = false)
    private String description;



    @ApiModelProperty(value = "是否直接上架 N否 Y是", required = false)
    private String directiveground;

    @ApiModelProperty(value = "暂存提交0 暂存 1提交", required = false)
    private Integer status;

    @ApiModelProperty(value = "操作类型 新增 编辑等", required = false)
    private String type;

    @ApiModelProperty(value = "流程实例号", required = false)
    private String instid;

    @ApiModelProperty(value = "商品编码", required = false)
    private String goodsNum;

    @ApiModelProperty(value = "主商品ID")
    private String priceId;

}
